<?php
/*------------------------------------------------------------------------

# Plg_wwmsocialshare : WWM Social Share On Image Hover

# ------------------------------------------------------------------------

# author    walkswithme.net

# copyright Copyright (C) 2013 walkswithme.net. All Rights Reserved.

# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

# Websites: http://www.walkswithme.net/

# Technical Support:  Forum - http://www.walkswithme.net/joomla-social-share-icons-on-image-hover

-------------------------------------------------------------------------*/
defined('_JEXEC') or die;


jimport('joomla.plugin.plugin');

class plgContentwwmsocialshare extends JPlugin{



function plgContentwwmsocialshare( &$subject, $params ){



    parent::__construct( $subject, $params );



}
public function onBeforeRender() {

        $app = JFactory::getApplication();
        $doc = JFactory::getDocument();
        $wwm_livepath = JURI::root(true) . '/plugins/content/wwmsocialshare/';

        $is_jquery = $this->params->get('is_jquery', 1);
        if ($is_jquery == 1) {

            $doc->addCustomtag('<script type="text/javascript" src="' . $wwm_livepath . 'js/jquery.js"></script>');
            $doc->addCustomtag('<script type="text/javascript">jQuery = jQuery.noConflict();</script>');

        }

        $doc->addCustomtag('<script type="text/javascript">' . $this->WWM_Custom_Js() . '</script>');




        $doc->addCustomtag('<script type="text/javascript" src="' . $wwm_livepath . 'js/wwm_custom.js"></script>');
        $doc->addStyleSheet($wwm_livepath . 'css/wwm_custom.css');


}

public function WWM_Custom_Js() {

        $fb_app_id = $this->params->get('fb_app_id','');

        if($this->params->get('is_fb') == 1 && $this->params->get('fb_app_id') != ""){
            $scripts .= '
              window.fbAsyncInit = function() {
                // init the FB JS SDK
                FB.init({
                  appId      : "'.$fb_app_id.'",
                  status     : true,
                  xfbml      : true
                });

              };';

        if($this->params->get('is_app_sdk')){
                $scripts .= ' // Load the SDK asynchronously
                (function(d, s, id){
                 var js, fjs = d.getElementsByTagName(s)[0];
                 if (d.getElementById(id)) {return;}
                 js = d.createElement(s); js.id = id;
                 js.src = "//connect.facebook.net/en_US/all.js";
                 fjs.parentNode.insertBefore(js, fjs);
               }(document, "script", "facebook-jssdk"));';
        }
       }


        $custome_js .= $scripts;

        return $custome_js;

    }
public function onContentPrepare($context, &$article, &$params, $page = 0){


        $alignment = $this->params->get('alignment', 1);
        $is_fb = $this->params->get('is_fb', 1);
        $is_gp = $this->params->get('is_gp', 1);
        $is_tw = $this->params->get('is_tw', 1);
        $is_ln = $this->params->get('is_ln', 1);
        $is_tm = $this->params->get('is_tm', 1);
        $is_pn = $this->params->get('is_pn', 1);
        $min_width = $this->params->get('min_width', 250);
        $force_fix = 0;//$this->params->get('force_fix', 0);

        $content = $article->text;


      switch($alignment){
        case 2 :
                 $align_class = 'wwm_top_left';
                 break;
        case 1 :
                 $align_class = 'wwm_top_right';
                 break;
        case 4 :
                 $align_class = 'wwm_bottom_left';
                 break;
        case 3 :
                 $align_class = 'wwm_bottom_right';
                 break;
        default :
                 $align_class = 'wwm_top_left';
                 break;
    }

   $ul = '<ul class="wwm_social_share '.$align_class.'">';
    if($is_fb == 1)
        $ul .= '<li class="wwm_facebook"></li>';
    if($is_tw == 1)
        $ul .= '<li class="wwm_twitter"></li>';
    if($is_gp == 1)
        $ul .= '<li class="wwm_gplus"></li>';
    if($is_pn == 1)
        $ul .= '<li class="wwm_pinit"></li>';
    if($is_tm == 1)
        $ul .= '<li class="wwm_tumblr"></li>';
    if($is_ln == 1)
        $ul .= '<li class="wwm_linked"></li>';
    $ul .= '</ul>';

   if($is_fb || $is_tw || $is_gp || $is_pn || $is_tm || $is_ln)
        $hidden_ul = $ul;
    else
        $hidden_ul = '';

    if($force_fix == 1){
      $alignment_fix = '<input type="hidden" id="force_fix" value="1" />';
    }else{
      $alignment_fix = '<input type="hidden" id="force_fix" value="0" />';
    }

    if(trim($content)!=''){
        libxml_use_internal_errors(true);
        $dom = new DOMDocument();

        $dom->loadHTML(mb_convert_encoding($content, 'HTML-ENTITIES', 'UTF-8'));
        $new_div = $dom->createElement('div');
        $new_div->setAttribute('class','wwm_socialshare_imagewrapper');
        $ImageList = $dom->getElementsByTagName('img');

        foreach($ImageList as $key => $Image)
        {

            if((int)$Image->getAttribute('width') > 0 && (int)$Image->getAttribute('width') < $min_width){
                //skip adding class
            }else{
                if($Image->parentNode->nodeName === 'a')
                {
                    $class_names = $Image->parentNode->getAttribute('class');
                    $Image->parentNode->setAttribute('class',$class_names.' wwm_socialshare_imagewrapper ');

                }else{

                    $new_div_clone = $new_div->cloneNode();
                    $Image->parentNode->replaceChild($new_div_clone,$Image);
                    $new_div_clone->appendChild($Image);

                }
            }
        }


    //Fixed the issue with additional html tags loading
    $content = preg_replace('/^<!DOCTYPE.+?>/', '', str_replace( array('<html>', '</html>', '<body>', '</body>'), array('', '', '', ''), $dom->saveHTML()));
    }

    $article->text =  $content.$hidden_ul.$alignment_fix;

}
















}
