<?php 
namespace Walkswithme\Users;
use Illuminate\Support\ServiceProvider;

class UsersServiceProvider extends ServiceProvider {

	/**
	 * Bootstrap the application services.
	 *
	 * @return void
	 */
	public function boot()
	{
		$this->loadViewsFrom(__DIR__.'/views', 'users');
		$this->publishes([
    					__DIR__.'/views' => base_path('resources/views/vendor/users'),
					]);
	}

	/**
	 * Register the application services.
	 *
	 * @return void
	 */
	public function register()
	{
		$this->app->make('Walkswithme\Users\UsersController');
		include __DIR__.'/routes.php';
		include __DIR__.'/events.php';
	}

}
