<?php
/*------------------------------------------------------------------------
# Plg_vmwwmzoom : WWM Related Products Slider for Virtuemart
# ------------------------------------------------------------------------
# author    walkswithme.net
# copyright Copyright (C) 2013 walkswithme.net. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.walkswithme.net/
# Technical Support:  Forum - http://www.walkswithme.net/related-products-slider-for-virtuemart
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');
if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}

jimport('joomla.application.component.helper');
class PlgSystemVmWWMRelatedProductsSlider extends JPlugin {

	public function onBeforeRender() {
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$view = JRequest::getVar('view');
		if ($app->isAdmin()) {
			return true;
		}
		if ($view != 'productdetails') {
			return true;
		}
		$pluginLivePath = JURI::root(true) . '/plugins/system/vmwwmrelatedproductsslider/';
		$show_jquery = $this->params->get('show_jquery', 1);
		if ($show_jquery == 1) {
			$doc->addScript('http://code.jquery.com/jquery-1.8.1.min.js');
		}
			//$doc->addScript($pluginLivePath.'js/jcarousel.js');
			$doc->addCustomtag('<script type="text/javascript" src="'.$pluginLivePath.'js/jcarousel.js"></script>');
			//$doc->addScript($pluginLivePath.'js/slider.js');
			$doc->addCustomtag('<script type="text/javascript" src="'.$pluginLivePath.'js/slider.js"></script>');
			$doc->addStyleSheet($pluginLivePath.'css/wwm_related_product_slider.css');	
			$doc->addStyleSheet($pluginLivePath.'css/jcarousel.css');
			$wwm_override = $this->params->get('wwm_override',0);
			if($wwm_override == 1){
				$style = ".product-field-type-R{display:none;}"; 
				$doc->addStyleDeclaration($style);
			}

	}
	public function onAfterRender() {
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$view = JRequest::getVar('view');
		if ($app->isAdmin()) {
			return true;
		}
		if ($view != 'productdetails') {
			return true;
		}
		$class_name = $this->params->get('class_name', 'product-field product-field-type-R');

		$buffer = JResponse::getBody();
		$getRelatedProduct = $this->getRelatedProducts();

		$wwm_override = $this->params->get('wwm_override',0);

		if($wwm_override == 0){
		$docs = new DOMDocument();
		libxml_use_internal_errors(true);
		$docs->resolveExternals = true;
		$docs->loadHTML(mb_convert_encoding($buffer, 'HTML-ENTITIES', 'UTF-8'));
		$element = $docs->createElement('div', $getRelatedProduct);
		$xpath = new DOMXPath($docs);
		$query = '//div[@class="'.$class_name.'"]';
		$entries = $xpath->query($query);
		foreach ($entries as $entry) {
		  
			$entry->parentNode->replaceChild($element, $entry);
		}
		$docs->recover = true;
		libxml_clear_errors();
		JResponse::setBody(htmlspecialchars_decode($docs->saveHTML()));

		
	  }else{
			
		$buffer = JResponse::getBody();	
		
		$regx = '/<div class="'.$class_name.'">([^`]*?)<\/div>/';		
		
		$buffer = preg_replace($regx,$getRelatedProduct,$buffer);		
		
		
			
		JResponse::setBody($buffer);

		
	  }

		return true;
	}

	function getRelatedProducts() {

		$thumbnail_width = $this->params->get('thumbnail_width', 110);
		$container_height = $this->params->get('container_height', 300);
		$show_price = $this->params->get('show_price', 1);
		$enable_addtocart = $this->params->get('enable_addtocart', 0);

		if (!class_exists('VmConfig')) {
			require JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_virtuemart' . DS . 'helpers' . DS . 'config.php';
		}

		if (!class_exists('shopFunctionsF')) {
			require VMPATH_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php';
		}

		$currency = CurrencyDisplay::getInstance();
		$config = VmConfig::loadConfig();
		$pluginLivePath = JURI::root(true) . '/plugins/system/vmwwmrelatedproductsslider/';
		$product_model = VmModel::getModel('product');
		$virtuemart_product_id = JRequest::getInt('virtuemart_product_id', 0);
		$product = $product_model->getProduct($virtuemart_product_id);

		$relatedproducts = array();
		foreach ($product->customfields as $items) {

			if ($items->field_type == "R") {
				$relatedproducts['product_id'][] = $items->customfield_value;
				$relatedproducts['product_title'][] = $items->display;
			}
		}

		$full_product_data = $product_model->getproducts($relatedproducts['product_id']);

		$html = "<div class='related_product_wrapper' style='height:" . $container_height . "px;'>";

		$controlls .= '<div class="WWM_slides_control">
					 <a id="prevs_wwm" class="prev1 jcarousel-control-prev-relatedproduct" href="javascript:;">prev</a>
					 <a class="next1 jcarousel-control-next-relatedproduct" id="nexts_wwm" href="javascript:;">next</a>
					 </div>';

		if (sizeof($relatedproducts['product_id']) > 0) {
			if ($this->params->get('enable_section_title', 1)) {
				$html .= "<div class='related_head'>" . $this->params->get('title', JText::_('COM_VIRTUEMART_RELATED_PRODUCTS')) . "</div>";
			}
			$html .= "<div class=\"WWM_rp_items jcarousel-wrapper\" ><div class='jcarousel-relatedproduct'><ul class='slider-relatedproduct'>";
			$count = 0;
			for ($i = 0; $i < sizeof($relatedproducts['product_id']); $i++) {

				
				$html .= '<li class="eachitem">'. $relatedproducts['product_title'][$i]. '</li>';
				$count++;
			}
		}
		$html .= '</ul></div>';

		$html .= $controlls . '</div></div>';
		return $html;
	}

}
