<?php
/*------------------------------------------------------------------------
# Plg_vmwwmzoom : WWM Related Products Slider for Virtuemart
# ------------------------------------------------------------------------
# author    walkswithme.net
# copyright Copyright (C) 2013 walkswithme.net. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.walkswithme.net/
# Technical Support:  Forum - http://www.walkswithme.net/related-products-slider-for-virtuemart
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );
if(!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
jimport('joomla.application.component.helper');
class PlgSystemVmWWMRelatedProductsSlider extends JPlugin{

	public function onBeforeRender() {
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$view = JRequest::getVar('view');
		if ($app->isAdmin()){
					return true;
				}
			if ($view !='productdetails'){
				return true;
			}
		$pluginLivePath = JURI::root(true).'/plugins/system/vmwwmrelatedproductsslider/';
		$show_jquery = $this->params->get('show_jquery',1);
			if($show_jquery==1){
				$doc->addScript('http://code.jquery.com/jquery-1.8.1.min.js');
			}
			$doc->addScript($pluginLivePath.'js/jcarousel.js');
			$doc->addScript($pluginLivePath.'js/slider.js');
			$doc->addScriptDeclaration($this->getCustomJs());
			$doc->addStyleSheet($pluginLivePath.'css/wwm_related_product_slider.css');	
			$doc->addStyleSheet($pluginLivePath.'css/jcarousel.css');

	}
	public function onAfterRender() {
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$view = JRequest::getVar('view');
		if ($app->isAdmin()){
				return true;
			}
		if ($view !='productdetails'){
			return true;
		}
		$class_name			 = 	$this->params->get('class_name','product-field product-field-type-R');
						
		$buffer = JResponse::getBody();	
		$getRelatedProduct = $this->getRelatedProducts();	
		

		$docs = new DOMDocument();
		libxml_use_internal_errors(true);
		$docs->resolveExternals = true;
		$docs->loadHTML($buffer);
		$element = $docs->createElement('div', $getRelatedProduct);
		$xpath = new DOMXPath($docs);
		$query = '//div[@class="'.$class_name.'"]';
		$entries = $xpath->query($query);
		foreach ($entries as $entry) {
		  
			$entry->parentNode->replaceChild($element, $entry);
		}
		$docs->recover = true;
		libxml_clear_errors();
		JResponse::setBody(htmlspecialchars_decode($docs->saveHTML()));

		$mainImageDiv = 'related_products';
			

		return true;
	}
	
	function getCustomJs(){
		
		
		$autoslide			 = 	$this->params->get('auto_slide',0);
		
		
		if (!class_exists( 'VmConfig' )) require(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'config.php');
		$config = VmConfig::loadConfig();
		$pluginLivePath = JURI::root(true).'/plugins/system/vmwwmrelatedproductsslider/';
		$product_model = VmModel::getModel('product');
		$virtuemart_product_id = JRequest::getInt('virtuemart_product_id', 0);
		$product = $product_model->getProduct($virtuemart_product_id);
		$relatedproducts = array();
		foreach($product->customfields as $items){

				if( $items->field_type == "R"){
				$relatedproducts['product_id'][] 	= $items->customfield_value;
				$relatedproducts['product_title'][] = $items->display;
				$relatedproducts['product_image'][] = $this->GetImage($items->customfield_value);
				}
		}
		
		$custome_js  = "";
		
		
		
	return $custome_js;
		
	}
	
	function GetImage($pid){
		$db = JFactory::getDBO();
		$sql = "SELECT * FROM #__virtuemart_medias WHERE file_type = 'product' AND virtuemart_media_id IN ( SELECT virtuemart_media_id FROM #__virtuemart_product_medias WHERE virtuemart_product_id = '$pid' ORDER BY ordering ASC) LIMIT 1";
		$db->setQuery($sql);
		$res = $db->LoadObject();
		return (sizeof($res) > 0) ? $res->file_url : '' ;
	}
	function getRelatedProducts(){

		$thumbnail_width			 = 	$this->params->get('thumbnail_width',110);
		$container_height			 = 	$this->params->get('container_height',300);
		if (!class_exists( 'VmConfig' )) require(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'config.php');
		$config = VmConfig::loadConfig();
		$pluginLivePath = JURI::root(true).'/plugins/system/vmwwmrelatedproductsslider/';
		$product_model = VmModel::getModel('product');
		$virtuemart_product_id = JRequest::getInt('virtuemart_product_id', 0);
		$product = $product_model->getProduct($virtuemart_product_id);
				
		$relatedproducts = array();
		foreach($product->customfields as $items){

				if( $items->field_type == "R"){
				$relatedproducts['product_id'][] 	= $items->customfield_value;
				$relatedproducts['product_title'][] = $items->display;
				$relatedproducts['product_image'][] = $this->GetImage($items->customfield_value);
				}
		}
		
		//print_r($relatedproducts);
		$html = "<div class='related_product_wrapper' style='height:".$container_height."px;'>";
		
			$controlls .= '<div class="WWM_slides_control">
					 <a id="prevs_wwm" class="prev1 jcarousel-control-prev-relatedproduct" href="javascript:;">prev</a>
					 <a class="next1 jcarousel-control-next-relatedproduct" id="nexts_wwm" href="javascript:;">next</a>
					 </div>';
			
		if(sizeof($relatedproducts['product_id']) > 0){
			if($this->params->get('enable_section_title',1)){
				$html .= "<div class='related_head'>".$this->params->get('title',JText::_('COM_VIRTUEMART_RELATED_PRODUCTS'))."</div>";
			}
			$html .= "<div class=\"WWM_rp_items jcarousel-wrapper\" ><div class='jcarousel-relatedproduct'><ul class='slider-relatedproduct'>";
			$count = 0;
			for($i = 0 ; $i < sizeof($relatedproducts['product_id']) ; $i++){
				if($relatedproducts['product_image'][$i] != ""){
					$img_link = '<img src="'.JURI::root().$relatedproducts['product_image'][$i].'" alt="'.strip_tags ($relatedproducts['product_title'][$i]).'" width="'.$thumbnail_width.'"  />';
				}else{
					$img_link = '<br/>';
				}
				 
				
				$item_data = new SimpleXMLElement($relatedproducts['product_title'][$i]);
				$item_link = $item_data['href'];
				$html .= '<li class="eachitem">
							<a href="'.$item_link.'" />'.
							$img_link.substr(strip_tags ($relatedproducts['product_title'][$i]),0,14)
						  .'</a></li>';
				$count++;
				}
			}
		$html .= '</ul></div>';
			
		$html .= $controlls.'</div></div>';
    return $html;
	}
	
	
	
	
	
}
