<?php
/*------------------------------------------------------------------------
# mod_latesttweets - WWM Tweets
# ------------------------------------------------------------------------
# author    walkswithme.net
# copyright Copyright (C) 2013 walkswithme.net. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.walkswithme.net/
# Technical Support:  Forum - http://www.walkswithme.net/latest-tweets-joomla-module
-------------------------------------------------------------------------*/
 // no direct access



defined( '_JEXEC' ) or die( 'Restricted access' );

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::root()."modules/mod_latesttweets/assets/css/tweets.css");
require_once(JPATH_SITE.'/modules/mod_latesttweets/assets/lib/twitteroauth.php');




 echo $result =  walkswithme_print_tweets($Latesttweets['consumer_key'],$Latesttweets['consumer_secret'],$Latesttweets['user_token'],$Latesttweets['user_secret'],$Latesttweets['user'], $Latesttweets['count'],50,$Latesttweets['width_options'],$Latesttweets['border_yes'],$Latesttweets['cache_yes']);
function walkswithme_capture_tweets($consumer_key,$consumer_secret,$user_token,$user_secret,$user, $count) {
	
	 $connection = getConnectionWithAccessToken($consumer_key,$consumer_secret,$user_token, $user_secret);
	$params = array(
		'screen_name' => $user,
		'count' => $count
	);
	
	$content = $connection->get("statuses/user_timeline",$params);
	
	//prar($content);
	
	return json_encode($content);
}

function getConnectionWithAccessToken($consumer_key,$consumer_secret,$oauth_token, $oauth_token_secret) {
	$connection = new TwitterOAuth($consumer_key, $consumer_secret, $oauth_token, $oauth_token_secret);
	return $connection;
}


function walkswithme_tweet_linkify($tweet) {
	$tweet = preg_replace("#(^|[\n ])([\w]+?://[\w]+[^ \"\n\r\t< ]*)#", "\\1<a href=\"\\2\" target=\"_blank\">\\2</a>", $tweet);
	$tweet = preg_replace("#(^|[\n ])((www|ftp)\.[^ \"\t\n\r< ]*)#", "\\1<a href=\"http://\\2\" target=\"_blank\">\\2</a>", $tweet);
	$tweet = preg_replace("/@(\w+)/", "<a href=\"http://www.twitter.com/\\1\" target=\"_blank\">@\\1</a>", $tweet);
	$tweet = preg_replace("/#(\w+)/", "<a href=\"http://search.twitter.com/search?q=\\1\" target=\"_blank\">#\\1</a>", $tweet);
	return $tweet;
}

function walkswithme_store_tweets($file, $tweets) {
    ob_start(); // turn on the output buffering 
    $fo = fopen($file, 'w'); // opens for writing only or will create if it's not there
    if (!$fo) return walkswithme_print_tweet_error(error_get_last());
    $fr = fwrite($fo, $tweets); // writes to the file what was grabbed from the previous function
    if (!$fr) return walkswithme_print_tweet_error(error_get_last());
    fclose($fo); // closes
    ob_end_flush(); // finishes and flushes the output buffer; 
}

function walkswithme_pick_tweets($file) {
    ob_start(); // turn on the output buffering 
    $fo = fopen($file, 'r'); // opens for reading only 
    if (!$fo) return walkswithme_print_tweet_error(error_get_last());
    $fr = fread($fo, filesize($file));
    if (!$fr) return walkswithme_print_tweet_error(error_get_last());
    fclose($fo);
    ob_end_flush();
    return $fr;
}

function walkswithme_print_tweet_error($errorArray) {
    return '<p class="eth-error">Error: ' . $errorArray['message'] . 'in ' . $errorArray['file'] . 'on line ' . $errorArray['line'] . '</p>';
}

function walkswithme_twitter_cache_enabled($cache_enable){
	if($cache_enable == 1)
		return true;
	else
		return false;
}

function walkswithme_print_tweets($consumer_key,$consumer_secret,$user_token,$user_secret,$user, $count, $cachetime=50,$width_options = 0,$border_options = 0,$cache_enable = 0) {
	if(walkswithme_twitter_cache_enabled($cache_enable)){
	    //setting the location to cache file
		//echo "here";
	    $cachefile = JPATH_SITE.'/modules/mod_latesttweets/assets/lib/twitterCache.json'; 
	    
	    // the file exitsts but is outdated, update the cache file
	    if (file_exists($cachefile) && ( time() - $cachetime > filemtime($cachefile)) && filesize($cachefile) > 0) {
	        //capturing fresh tweets
			$tweets_decoded['error'] = array();
	        $tweets = walkswithme_capture_tweets($consumer_key,$consumer_secret,$user_token,$user_secret,$user, $count);
	        $tweets_decoded = json_decode($tweets, true);
	        //if get error while loading fresh tweets - load outdated file
	        if($tweets_decoded['error']) {
	            $tweets = walkswithme_pick_tweets($cachefile);
	        }
	        //else store fresh tweets to cache
	        else
	            walkswithme_store_tweets($cachefile, $tweets);
	    }
	    //file doesn't exist or is empty, create new cache file
	    elseif (!file_exists($cachefile) || filesize($cachefile) == 0) {
	        $tweets = walkswithme_capture_tweets($consumer_key,$consumer_secret,$user_token,$user_secret,$user, $count);
	        $tweets_decoded = json_decode($tweets, true);
	        //if request fails, and there is no old cache file - print error
	        if($tweets_decoded['error'])
	            return 'Error: ' . $tweets_decoded['error'];
	        //make new cache file with request results
	        else
	            walkswithme_store_tweets($cachefile, $tweets);            
	    }
	    //file exists and is fresh
	    //load the cache file
	    else { 
	       $tweets = walkswithme_pick_tweets($cachefile);
	    }
	} else{
       $tweets = walkswithme_capture_tweets($consumer_key,$consumer_secret,$user_token,$user_secret,$user, $count);
	}

    $tweets = json_decode($tweets, true);
    $html = '';
	
	if($border_options ==1)
		$border_st = 'border_style';
	else
		$border_st = "";
	if($width_options > 0)
		$width_style = 'style="width:'.$width_options.'px"';
	else
		$width_style = "";
		
    foreach ($tweets as $tweet) {
        $html .= '<div class="tweets1"> 
					<div class="float_left">
					<img src="'.$tweet['user']['profile_image_url'].'" />
					</div>
					<div class="tweet_msg '.$border_st.'" '.$width_style.'>'.$tweet['text']. '\t<i>...On '.date("M-d",strtotime($tweet['created_at'])).'</i>
					</div>
				</div>';
    }
    $html = walkswithme_tweet_linkify($html);
    return $html;
}

?>