<?php
/*------------------------------------------------------------------------
# wwm_contactinviter : WWM Contact Inviter
# ------------------------------------------------------------------------
# author    walkswithme.net
# copyright Copyright (C) 2013 walkswithme.net. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.walkswithme.net/
# Technical Support:  Forum - http://www.walkswithme.net/elgg-social-contact-importer-and-inviter
-------------------------------------------------------------------------*/

elgg_register_event_handler('init', 'system', 'wwm_contactinviter_init');

function wwm_contactinviter_init() {
	elgg_register_page_handler('contactimporter', 'wwm_contactinviter_page_handler');

	elgg_register_action('wwm_contactinviter/contactimporter', elgg_get_plugins_path() . 'wwm_contactinviter/actions/contactimporter.php');
	$ts = time();
	elgg_register_action('wwm_contactinviter/gmailcallback',
						TRUE,
						elgg_get_plugins_path() . 'wwm_contactinviter/actions/gmailcallback.php?__elgg_token='.generate_action_token($ts).'&__elgg_ts='.$ts);

	if (elgg_is_logged_in()) {
		$params = array(
			'name' => 'contactimporter',
			'text' => elgg_echo('friends:contactimporter'),
			'href' => "contactimporter",
			'contexts' => array('friends'),
		);
		elgg_register_menu_item('page', $params);
	}
}

/**
 * Page handler function
 * 
 * @param array $page Page URL segments
 * @return bool
 */
function wwm_contactinviter_page_handler($page) {
	gatekeeper();

	elgg_set_context('friends');
	elgg_set_page_owner_guid(elgg_get_logged_in_user_guid());

	$title = elgg_echo('friends:contactimporter');

	$body = elgg_view('wwm_contactinviter/form');

	$params = array(
		'content' => $body,
		'title' => $title,
	);
	$body = elgg_view_layout('one_sidebar', $params);

	echo elgg_view_page($title, $body);
	return true;
}
