<?php
/*------------------------------------------------------------------------
# Plg_hikashopwwmzoompro : WWM Product Zoom Pro for Hikashop
# ------------------------------------------------------------------------
# author    walkswithme.net
# copyright Copyright (C) 2013 walkswithme.net. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.walkswithme.net/
# Technical Support:  Forum - http://www.walkswithme.net/joomla-hikashop-product-image-zoom
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );
if(!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
jimport('joomla.application.component.helper');
class PlgSystemHikaShopWWMZoomPro extends JPlugin{

	public function onBeforeRender() {
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$view = JRequest::getVar('view');
		
		$option = JRequest::getString('option');
		$ctrl = JRequest::getString('ctrl');
		$task = JRequest::getString('task');

		if ($option!='com_hikashop'||$ctrl!='product'||$task!='show') return true;
		
		if ($app->isAdmin()){
					return true;
				}
			
		$wwm_livepath = JURI::root(true).'/plugins/system/hikashopwwmzoompro/';
		$show_jquery = $this->params->get('show_jquery',1);
			if($show_jquery==1){
				$doc->addCustomtag('<script type="text/javascript" src="'.$wwm_livepath.'js/jquery.js"></script>');
				$doc->addCustomtag('<script type="text/javascript">jQuery.noConflict();</script>');
			}
			$doc->addCustomtag('<script type="text/javascript" src="'.$wwm_livepath.'js/jquery.nicescroll.min.js"></script>');
			$doc->addCustomtag('<script type="text/javascript" src="'.$wwm_livepath.'js/jquery.mousewheel.js"></script>');
			$doc->addCustomtag('<script type="text/javascript" src="'.$wwm_livepath.'js/touch.js"></script>');
			$doc->addCustomtag('<script type="text/javascript" src="'.$wwm_livepath.'js/zoom.js"></script>');
			
			$doc->addCustomtag('<script type="text/javascript">'.$this->WWM_Custom_Js().'</script>');
			if($this->params->get('slider',1)){
				$doc->addCustomtag('<script type="text/javascript" src="'.$wwm_livepath.'js/jcarousel.js"></script>');
				$doc->addCustomtag('<script type="text/javascript" src="'.$wwm_livepath.'js/slider.js"></script>');
			}
			$doc->addStyleSheet($wwm_livepath.'css/zoom.css');	
			if($this->params->get('slider',1))
				$doc->addStyleSheet($wwm_livepath.'css/jcarousel.css');	
			
	}
	public function onAfterRender() {
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$view = JRequest::getVar('view');
		if ($app->isAdmin()){
				return true;
			}
		$option = JRequest::getString('option');
		$ctrl = JRequest::getString('ctrl');
		$task = JRequest::getString('task');
		if ($option!='com_hikashop'||$ctrl!='product'||$task!='show') return true;
						
		$buffer = JResponse::getBody();		
		
		$WWM_Main_Image 	= $this->WWM_Main_Image();
		$WWM_Other_Images	= $this->WWM_Other_Images();
		
		
		$mainImageDiv		= $this->params->get('mainImagediv','hikashop_main_image_div');
		$otherImagediv		= $this->params->get('otherImagediv','hikashop_small_image_div');
		
		$docs = new DOMDocument();

		libxml_use_internal_errors(true);

		$doc->resolveExternals = true;

		$docs->loadHTML(mb_convert_encoding($buffer, 'HTML-ENTITIES', 'UTF-8'));

		$docs->GetElementById($mainImageDiv)->nodeValue = $WWM_Main_Image;

		@$docs->GetElementById($otherImagediv)->nodeValue = $WWM_Other_Images;

		$docs->recover = true;

		libxml_clear_errors();

		JResponse::setBody(htmlspecialchars_decode($docs->saveHTML()));

		return true;
	}
	
	function WWM_Custom_Js(){
		
		$zoomType = 		$this->params->get('zoomType','dock');
		$slider			 = 	$this->params->get('slider',1);
		
		
		
		
		$custome_js  = "";
		
		
		
		
			$custome_js  .= "jQuery(document).ready(function(){
			jQuery('a#zoom1').swinxyzoom({mode:'".$zoomType."', controls: false, size: '100%', dock: { position: 'right' } });
			
			jQuery('.views-gallery .slider a').click(function(e) {
				e.preventDefault();
				
				
				var $this = jQuery(this),
				  largeImage  = $this.attr('href');
				  smallImage  = $this.data('easyzoom-source');
				
                if (!$this.parent().hasClass('thumbnail-active')) {
					jQuery('a#zoom1').swinxyzoom('load', smallImage,  largeImage);
					jQuery('.lightbox-btn').attr('href', largeImage);
					
					jQuery('.views-gallery li').removeClass('thumbnail-active');
					jQuery(this).parent().addClass('thumbnail-active');
				}
				
			});
    	});";
		
		
	return $custome_js;
		
	}
	
	function WWM_Main_Image(){
		
		
		$config =& hikashop_config();
		$wwm_livepath = JURI::root(true).'/plugins/system/vmwwmzoompro/';
		$db = JFactory::getDBO();
		$product_id = (int)hikashop_getCID('product_id');
		
		$queryImage = 'SELECT * FROM ' . hikashop_table('file') . ' WHERE file_ref_id IN (' . $product_id . ') AND file_type=\'product\' ORDER BY file_ordering ASC, file_id ASC LIMIT 1';
		$db->setQuery($queryImage);
		$images = $db->loadObjectList();
		$productClass 	= 	hikashop_get('class.product');
		$imageHelper	=	hikashop_get('helper.image');
			
			
	
		$j = count($images);
		$imageWidth = 		trim($this->params->get('imageWidth',350));
		$imageHeight = 		trim($this->params->get('imageHeight'));
		
		$imageZoomWidth  = 		trim($this->params->get('imageZoomWidth',800));
		$imageZoomHeight = 		trim($this->params->get('imageZoomHeight',800));
		$containerwidth 	= 		trim($this->params->get('containerwidth',100));
		//add HTML
		$slider			 = 	$this->params->get('slider',1);
		
		$html = '';
		$image_options = array();
		
		
		foreach($images as $image){
			
		$img = $imageHelper->getThumbnail(@$image->file_path, array('width' => $imageWidth, 'height' => $imageHeight), $image_options);
		$imgfull = $imageHelper->getThumbnail(@$image->file_path, array('width' => $imageZoomWidth, 'height' => $imageZoomHeight), $image_options);
		
		if(isset($img->url)){
			$zoom_url  = @$imgfull->url;
			$image_url = @$img->url;
		}else{
			$zoom_url  = JURI::root()."plugins/system/hikashopwwmzoompro/images/noimage_zoom.png";
			$image_url = JURI::root()."plugins/system/hikashopwwmzoompro/images/noimage.png";
		}
		$html .= "<div style='width:".$containerwidth."%;'>";
		$html .= "<a id='zoom1' class='zoom' href='".$zoom_url."'><img src ='".$image_url."'
             width='".$imageWidth."' height='".$imageHeight."' /></a>";
		
		}
			
	
		$html .= '</div>';
		
		
    	return $html;
	}
	
	
	function WWM_Other_Images(){
		
		$config =& hikashop_config();
		$wwm_livepath = JURI::root(true).'/plugins/system/vmwwmzoompro/';
		$db = JFactory::getDBO();
		$product_id = (int)hikashop_getCID('product_id');
		
	
		$queryImage = 'SELECT * FROM ' . hikashop_table('file') . ' WHERE file_ref_id IN (' . $product_id . ') AND file_type=\'product\' ORDER BY file_ordering ASC, file_id ASC';
		$db->setQuery($queryImage);
		$images = $db->loadObjectList();
		$productClass 	= 	hikashop_get('class.product');
		$imageHelper	=	hikashop_get('helper.image');
		
		$thumbimageWidth  = 		trim($this->params->get('thumbimageWidth',80));
		$thumbimageHeight = 		trim($this->params->get('thumbimageHeight',65));
		$imageZoomWidth   = 		trim($this->params->get('imageZoomWidth',800));
		$imageZoomHeight  = 		trim($this->params->get('imageZoomHeight',800));
		
		$j = count($images);
		$htmlcontent = "";
		if($j > 1){
		$htmlcontent = "<div id=\"WWM_thumbs_images\"  class='views-gallery jcarousel-wrapper'>
					<div class='jcarousel'>
					<ul class='slider'>";
					
		$image_options = array();
		$count = 1;
		foreach($images as $image){
			
			if($count == 1)
			 $first_thumb_active = 'class="thumbnail-active"';
			else
			 $first_thumb_active = '';
			
		$img = $imageHelper->getThumbnail(@$image->file_path, array('width' => $thumbimageWidth, 'height' => $thumbimageHeight), $image_options);
		$imgfull = $imageHelper->getThumbnail(@$image->file_path, array('width' => $imageZoomWidth, 'height' => $imageZoomHeight), $image_options);
		
		$htmlcontent .= "<li style='width:".($thumbimageWidth)."px' ".$first_thumb_active."><a class='image' href='".$imgfull->url."' data-easyzoom-source='".$imgfull->url."'>
		<img style=\"width:".$thumbimageWidth."px !important;height:auto !important;\"   src='".$img->url."' class='attachment-shop_thumbnail'>
                </a></li>";
				$count++;
		
		}
			
		
		
		if($this->params->get('slider',1)){
			$controls = '<a  class="jcarousel-control-prev" href="javascript:;"></a>
				    <a class="jcarousel-control-next" id="next_wwm" href="javascript:;"></a>';
		}else{
			$controls = '';
		}
		
		$htmlcontent .= '</ul></div>'.$controls.'</div>';
		}
		
				
    return $htmlcontent;
	}
	
	
}
