(function (y) {
	var T = {
		topLeft: ["top", "left"],
		top: ["top", "center"],
		topRight: ["top", "right"],
		bottomLeft: ["bottom", "left"],
		bottom: ["bottom", "center"],
		bottomRight: ["bottom", "right"],
		leftTop: ["left", "top"],
		left: ["left", "center"],
		leftBottom: ["left", "bottom"],
		rightTop: ["right", "top"],
		right: ["right", "center"],
		rightBottom: ["right", "bottom"]
	};
	var p = {
		fade: ["vCover", "fade"],
		zoomIn: ["vCover", "zoom"],
		zoomOut: ["vCover", "zoom"],
		coverDown: ["vCover", "sliceDown"],
		coverUp: ["vCover", "sliceUp"],
		coverRight: ["hCover", "sliceRight"],
		coverLeft: ["hCover", "sliceLeft"],
		blockExpandDown: ["blocks", "expand"],
		blockExpandUp: ["blocks", "expand"],
		blockExpandRight: ["blocks", "expand"],
		blockExpandLeft: ["blocks", "expand"],
		diagonalFade: ["blocks", "diagonalFade"],
		reverseDiagonalFade: ["blocks", "diagonalFade"],
		diagonalExpand: ["blocks", "diagonalExpand"],
		reverseDiagonalExpand: ["blocks", "diagonalExpand"],
		diagonalShift: ["blocks", "diagonalShift"],
		reverseDiagonalShift: ["blocks", "diagonalShift"],
		blockRandomFade: ["blocks", "randomEffect"],
		blockRandomExpand: ["blocks", "randomEffect"],
		blockRandomDrop: ["blocks", "randomEffect"],
		zigZagDown: ["blocks", "zigZag"],
		zigZagUp: ["blocks", "zigZag"],
		zigZagRight: ["blocks", "zigZag"],
		zigZagLeft: ["blocks", "zigZag"],
		spiralIn: ["blocks", "spiral"],
		spiralOut: ["blocks", "spiral"],
		sliceDownRight: ["vSlices", "sliceDown"],
		sliceDownLeft: ["vSlices", "sliceDown"],
		sliceDownRandom: ["vSlices", "sliceDown"],
		sliceUpRight: ["vSlices", "sliceUp"],
		sliceUpLeft: ["vSlices", "sliceUp"],
		sliceUpRandom: ["vSlices", "sliceUp"],
		sliceFadeRight: ["vSlices", "fade"],
		sliceFadeLeft: ["vSlices", "fade"],
		verticalRandomFade: ["vSlices", "fade"],
		sliceAltRight: ["vSlices", "sliceAlt"],
		sliceAltLeft: ["vSlices", "sliceAlt"],
		blindsRight: ["vSlices", "blinds"],
		blindsLeft: ["vSlices", "blinds"],
		verticalRandomBlinds: ["vSlices", "blinds"],
		sliceMoveRight: ["vSlices", "move"],
		sliceMoveLeft: ["vSlices", "move"],
		sliceRightDown: ["hSlices", "sliceRight"],
		sliceRightUp: ["hSlices", "sliceRight"],
		sliceRightRandom: ["hSlices", "sliceRight"],
		sliceLeftDown: ["hSlices", "sliceLeft"],
		sliceLeftUp: ["hSlices", "sliceLeft"],
		sliceLeftRandom: ["hSlices", "sliceLeft"],
		sliceFadeDown: ["hSlices", "fade"],
		sliceFadeUp: ["hSlices", "fade"],
		horizontalRandomFade: ["hSlices", "fade"],
		sliceAltDown: ["hSlices", "sliceAlt"],
		sliceAltUp: ["hSlices", "sliceAlt"],
		blindsDown: ["hSlices", "blinds"],
		blindsUp: ["hSlices", "blinds"],
		horizontalRandomBlinds: ["hSlices", "blinds"],
		sliceMoveDown: ["hSlices", "move"],
		sliceMoveUp: ["hSlices", "move"],
		horizontalSlide: ["hSlide", "slide"],
		verticalSlide: ["vSlide", "slide"]
	};
	var R = "ontouchstart" in window;
	var q = a();
	var r = a(6);
	var M = 500;
	var g = 50;
	var B = "updateThumbnails";
	var b = "resizeControlPanel";
	var d = "updateSize";
	var u = "rotator";
	var e = "rotatorInit";
	var h = "rotatorSlideChange";
	var Q = "rotatorSlideComplete";
	var H = "rotatorFirst";
	var w = "rotatorLast";
	var L = "rotatorPlay";
	var t = "rotatorPause";
	var N = "rotatorPrevious";
	var n = "rotatorNext";
	var K = {
		linear: "linear",
		"": "ease",
		swing: "ease",
		ease: "ease",
		"ease-in": "ease-in",
		"ease-out": "ease-out",
		"ease-in-out": "ease-in-out",
		easeInQuad: "cubic-bezier(.55,.085,.68,.53)",
		easeOutQuad: "cubic-bezier(.25,.46,.45,.94)",
		easeInOutQuad: "cubic-bezier(.455,.03,.515,.955)",
		easeInCubic: "cubic-bezier(.55,.055,.675,.19)",
		easeOutCubic: "cubic-bezier(.215,.61,.355,1)",
		easeInOutCubic: "cubic-bezier(.645,.045,.355,1)",
		easeInQuart: "cubic-bezier(.895,.03,.685,.22)",
		easeOutQuart: "cubic-bezier(.165,.84,.44,1)",
		easeInOutQuart: "cubic-bezier(.77,0,.175,1)",
		easeInQuint: "cubic-bezier(.755,.05,.855,.06)",
		easeOutQuint: "cubic-bezier(.23,1,.32,1)",
		easeInOutQuint: "cubic-bezier(.86,0,.07,1)",
		easeInSine: "cubic-bezier(.47,0,.745,.715)",
		easeOutSine: "cubic-bezier(.39,.575,.565,1)",
		easeInOutSine: "cubic-bezier(.445,.05,.55,.95)",
		easeInExpo: "cubic-bezier(.95,.05,.795,.035)",
		easeOutExpo: "cubic-bezier(.19,1,.22,1)",
		easeInOutExpo: "cubic-bezier(1,0,0,1)",
		easeInCirc: "cubic-bezier(.6,.04,.98,.335)",
		easeOutCirc: "cubic-bezier(.075,.82,.165,1)",
		easeInOutCirc: "cubic-bezier(.785,.135,.15,.86)",
		easeInBack: "cubic-bezier(.60,-.28,.735,.045)",
		easeOutBack: "cubic-bezier(.175,.885,.32,1.275)",
		easeInOutBack: "cubic-bezier(.68,-.55,.265,1.55)"
	};
	l("transform");
	l("transition");
	l("backgroundSize");
	l("borderRadius");
	var f;
	var O;
	switch (y.support.transition) {
	case "transition":
		f = "transition";
		O = "transitionend";
		break;
	case "WebkitTransition":
		f = "-webkit-transition";
		O = "webkitTransitionEnd";
		break;
	case "MozTransition":
		f = "-moz-transition";
		O = "transitionend";
		break;
	case "OTransition":
		f = "-o-transition";
		O = "oTransitionEnd";
		break
	}
	function v(V, X) {
		this._$timer = y("<div></div>").addClass("br-bar-timer");
		var W = E(T[X], T.top);
		this._$timer.addClass("bottom" === W[0] ? "br-bottom": "br-top");
		V.append(this._$timer)
	}
	v.prototype = {
		start: function (V) {
			this._$timer.animate({
				width: "101%"
			},
			{
				duration: V,
				easing: "linear",
				queue: false
			})
		},
		stop: function () {
			this._$timer.stop().width(0)
		},
		pause: function () {
			this._$timer.stop()
		}
	};
	function U(V, X) {
		this._$timer = y('<div class="br-pie-timer">							<div class="br-rside"><div class="br-rotate"></div></div>						   	<div class="br-lside"><div class="br-rotate"></div></div>						  </div>').css({
			opacity: 0
		});
		var W = E(T[X], T.topRight);
		this._$timer.css(W[0], 0).css(W[1], 0);
		this._$left = this._$timer.find(">.br-lside .br-rotate");
		this._$right = this._$timer.find(">.br-rside .br-rotate");
		this._elapsed = this._delay = 0;
		this._intervalId = null;
		V.append(this._$timer)
	}
	U.prototype = {
		start: function (V) {
			if (0 === this._delay) {
				this._delay = V;
				this._$timer.stopTransition(true).transition({
					opacity: 0.75
				},
				M, "");
				this._$left.add(this._$right).css({
					transform: "rotateZ(0deg)"
				})
			}
			this._intervalId = setInterval(y.proxy(function () {
				this._elapsed += 50;
				var X = this._elapsed / this._delay,
				W = X * 360;
				if (X <= 0.5) {
					this._$right.css({
						transform: "rotateZ(" + W + "deg)"
					})
				} else {
					this._$left.css({
						transform: "rotateZ(" + (W - 180) + "deg)"
					})
				}
			},
			this), 50)
		},
		stop: function () {
			clearInterval(this._intervalId);
			this._elapsed = this._delay = 0;
			this._$left.add(this._$right).css({
				transform: "rotateZ(180deg)"
			});
			this._$timer.stopTransition(true).transition({
				opacity: 0
			},
			M, "")
		},
		pause: function () {
			clearInterval(this._intervalId)
		}
	};
	function m(W, V) {
		this._parent = W;
		this._intervalId = null;
		this._delay = V
	}
	m.prototype = {
		create: function (V) {
			var W = this._total,
			X = "",
			Y = this._parent._$screen.find(">.br-effects");
			while (W--) {
				X += '<div class="' + V + '"></div>'
			}
			Y.append(X);
			$el = Y.children("." + V).slice( - this._total);
			if ("none" === this._parent._$screen.css("backgroundImage")) {
				$el.css({
					backgroundColor: this._parent._$screen.css("backgroundColor")
				})
			}
			return $el
		},
		clear: function () {
			clearInterval(this._intervalId);
			this._$el.stopTransition(true, false).css({
				visibility: "hidden"
			});
			this._parent._inProgress = false
		},
		resize: function (V) {
			this.clear();
			this._width = Math.ceil(this._$el.data("width") * V);
			this._height = Math.ceil(this._$el.data("height") * V)
		},
		setImage: function (V, W) {
			V.find(">img").remove();
			V.append(y('<img src="' + W.attr("src") + '" alt=""/>').css({
				top: W.css("top"),
				left: W.css("left")
			}).width(W.width()).height(W.height()))
		},
		setBgImage: function (V, W) {
			V.css({
				backgroundImage: "url(" + W.attr("src") + ")",
				backgroundSize: W.css("width") + " " + W.css("height"),
				backgroundPosition: W.css("left") + " " + W.css("top")
			})
		},
		animate: function (Z, W, Y, aa) {
			var V = 0,
			X = this._total - 1;
			this._intervalId = setInterval(y.proxy(function () {
				if (V !== X) {
					y(Z[V]).transition(W, Y, aa)
				} else {
					y(Z[V]).transition(W, Y, aa, y.proxy(function () {
						this._parent.displayCurrent();
						this._$el.css({
							visibility: "hidden"
						})
					},
					this))
				}
				if (++V == this._total) {
					clearInterval(this._intervalId)
				}
			},
			this), this._delay)
		}
	};
	I.prototype = new m();
	I.prototype.constructor = I;
	function I(X, V) {
		m.call(this, X, 0);
		this._orientation = V;
		this._total = 1;
		var W;
		if ("vertical" === this._orientation) {
			this._position = "top";
			W = "br-vslide"
		} else {
			this._position = "left";
			W = "br-hslide"
		}
		this._$el = this.create(W).append("<div></div><div></div>");
		this._$slides = this._$el.children()
	}
	I.prototype.slide = function (ab, ad, X, Y) {
		var V, aa, Z = {},
		W = this._parent._$prevItem.find(">img.br-main-img"),
		ac = ("vertical" === this._orientation) ? -this._$slides.height() : -this._$slides.width();
		if (this._parent._backward) {
			aa = this._$slides.first();
			V = this._$slides.last();
			this._$el.css(this._position, ac);
			Z[this._position] = 0
		} else {
			aa = this._$slides.last();
			V = this._$slides.first();
			this._$el.css(this._position, 0);
			Z[this._position] = ac
		}
		if (y.support.backgroundSize) {
			this.setBgImage(V, W);
			this.setBgImage(aa, ab)
		} else {
			this.setImage(V, W);
			this.setImage(aa, ab)
		}
		this._$el.css({
			visibility: "visible"
		});
		this._parent._$items.css({
			visibility: "hidden"
		});
		this.animate(this._$el.toArray(), Z, X, Y)
	};
	S.prototype = new m();
	S.prototype.constructor = S;
	function S(W, X, V) {
		m.call(this, W, V);
		this._cssTransform = this._parent._cssTransform;
		this._total = X;
		this._width = Math.ceil(this._parent._stageWidth / this._total);
		this._$el = this.create("br-vslice").data({
			width: this._width
		})
	}
	S.prototype.sliceDown = function (V, W, X, Z) {
		var Y = this._$el.toArray();
		if ("sliceDownLeft" === W) {
			Y.reverse()
		} else {
			if ("sliceDownRandom" === W) {
				o(Y)
			}
		}
		if (this._cssTransform) {
			this.set(V, {
				transform: "translateY(-100%)"
			});
			this.animate(Y, {
				transform: "translateY(0)"
			},
			X, Z)
		} else {
			this.set(V, {
				top: -this._$el.height()
			});
			this.animate(Y, {
				top: 0
			},
			X, Z)
		}
	};
	S.prototype.sliceUp = function (V, W, X, Z) {
		var Y = this._$el.toArray();
		if ("sliceUpLeft" === W) {
			Y.reverse()
		} else {
			if ("sliceUpRandom" === W) {
				o(Y)
			}
		}
		if (this._cssTransform) {
			this.set(V, {
				transform: "translateY(100%)"
			});
			this.animate(Y, {
				transform: "translateY(0)"
			},
			X, Z)
		} else {
			this.set(V, {
				top: this._$el.height()
			});
			this.animate(Y, {
				top: 0
			},
			X, Z)
		}
	};
	S.prototype.sliceAlt = function (V, W, X, Z) {
		var Y = this._$el.toArray();
		if ("sliceAltLeft" === W) {
			Y.reverse()
		}
		if (this._cssTransform) {
			this.set(V, {
				transform: "translateY(-100%)"
			});
			this._$el.filter(":odd").css({
				transform: "translateY(100%)"
			});
			this.animate(Y, {
				transform: "translateY(0)"
			},
			X, Z)
		} else {
			this.set(V, {
				top: -this._$el.height()
			});
			this._$el.filter(":odd").css({
				top: this._$el.height()
			});
			this.animate(Y, {
				top: 0
			},
			X, Z)
		}
	};
	S.prototype.blinds = function (V, W, X, Z) {
		this.set(V, {
			width: 0
		});
		var Y = this._$el.toArray();
		if ("blindsLeft" === W) {
			Y.reverse()
		} else {
			if ("verticalRandomBlinds" === W) {
				o(Y)
			}
		}
		this.animate(Y, {
			width: this._width + "px"
		},
		X, Z)
	};
	S.prototype.fade = function (V, W, X, Z) {
		this.set(V, {
			opacity: 0
		});
		var Y = this._$el.toArray();
		if ("sliceFadeLeft" === W) {
			Y.reverse()
		} else {
			if ("verticalRandomFade" === W) {
				o(Y)
			}
		}
		this.animate(Y, {
			opacity: 1
		},
		X, Z)
	};
	S.prototype.move = function (V, X, Y, aa) {
		var Z = this._$el.toArray(),
		W = this._$el.parent().width();
		if ("sliceMoveRight" === X) {
			Z.reverse();
			W *= -1
		}
		if (this._cssTransform) {
			this.set(V, {
				transform: "translateX(" + W + "px)"
			});
			this.animate(Z, {
				transform: "translateX(0)"
			},
			Y, aa)
		} else {
			this.set(V, {
				left: "+=" + W
			});
			this.animate(Z, {
				left: "-=" + W
			},
			Y, aa)
		}
	};
	S.prototype.zoom = function (V, W, X, Y) {
		if (this._cssTransform) {
			this.set(V, "zoomOut" === W ? {
				transform: "scale(2)"
			}: {
				transform: "scale(0)"
			});
			this.animate(this._$el.toArray(), {
				transform: "scale(1)"
			},
			X, Y)
		} else {
			this.fade(V, W, X, Y)
		}
	};
	S.prototype.set = function (W, V) {
		var X = W.position().left;
		if (y.support.backgroundSize) {
			this.setBgImage(this._$el, W)
		} else {
			this.setImage(this._$el, W)
		}
		var Y = this._$el.parent().width();
		this._$el.each(y.proxy(function (ad, ab) {
			var aa = Math.min(this._width, Y),
			ac = ad * this._width,
			Z = (X - ac) + "px";
			y(ab).css({
				left: ac + "px"
			}).width(aa);
			if (y.support.backgroundSize) {
				y(ab).css({
					backgroundPosition: Z + " " + W.css("top")
				})
			} else {
				y(ab).find(">img").css({
					left: Z
				})
			}
			Y -= aa
		},
		this));
		this._$el.css(y.extend({
			opacity: 1,
			top: 0,
			visibility: "visible",
			transform: ""
		},
		V))
	};
	P.prototype = new m();
	P.prototype.constructor = P;
	function P(W, X, V) {
		m.call(this, W, V);
		this._cssTransform = this._parent._cssTransform;
		this._total = X;
		this._height = Math.ceil(this._parent._stageHeight / this._total);
		this._$el = this.create("br-hslice").data({
			height: this._height
		})
	}
	P.prototype.sliceRight = function (V, W, X, Z) {
		var Y = this._$el.toArray();
		if ("sliceRightUp" === W) {
			Y.reverse()
		} else {
			if ("sliceRightRandom" === W) {
				o(Y)
			}
		}
		if (this._cssTransform) {
			this.set(V, {
				transform: "translateX(-100%)"
			});
			this.animate(Y, {
				transform: "translateX(0)"
			},
			X, Z)
		} else {
			this.set(V, {
				left: -this._$el.width()
			});
			this.animate(Y, {
				left: 0
			},
			X, Z)
		}
	};
	P.prototype.sliceLeft = function (V, W, X, Z) {
		var Y = this._$el.toArray();
		if ("sliceLeftUp" === W) {
			Y.reverse()
		} else {
			if ("sliceLeftRandom" === W) {
				o(Y)
			}
		}
		if (this._cssTransform) {
			this.set(V, {
				transform: "translateX(100%)"
			});
			this.animate(Y, {
				transform: "translateX(0)"
			},
			X, Z)
		} else {
			this.set(V, {
				left: this._$el.width()
			});
			this.animate(Y, {
				left: 0
			},
			X, Z)
		}
	};
	P.prototype.sliceAlt = function (V, W, X, Z) {
		var Y = this._$el.toArray();
		if ("sliceAltUp" === W) {
			Y.reverse()
		}
		if (this._cssTransform) {
			this.set(V, {
				transform: "translateX(-100%)"
			});
			this._$el.filter(":odd").css({
				transform: "translateX(100%)"
			});
			this.animate(Y, {
				transform: "translateX(0)"
			},
			X, Z)
		} else {
			this.set(V, {
				left: -this._$el.width()
			});
			this._$el.filter(":odd").css({
				left: this._$el.width()
			});
			this.animate(Y, {
				left: 0
			},
			X, Z)
		}
	};
	P.prototype.blinds = function (V, W, X, Z) {
		this.set(V, {
			height: 0
		});
		var Y = this._$el.toArray();
		if ("blindsUp" === W) {
			Y.reverse()
		} else {
			if ("horizontalRandomBlinds" === W) {
				o(Y)
			}
		}
		this.animate(Y, {
			height: this._height + "px"
		},
		X, Z)
	};
	P.prototype.fade = function (V, W, X, Z) {
		this.set(V, {
			opacity: 0
		});
		var Y = this._$el.toArray();
		if ("sliceFadeUp" === W) {
			Y.reverse()
		} else {
			if ("horizontalRandomFade" === W) {
				o(Y)
			}
		}
		this.animate(Y, {
			opacity: 1
		},
		X, Z)
	};
	P.prototype.move = function (W, X, Y, aa) {
		var Z = this._$el.toArray(),
		V = this._$el.parent().height();
		if ("sliceMoveDown" === X) {
			Z.reverse();
			V *= -1
		}
		if (this._cssTransform) {
			this.set(W, {
				transform: "translateY(" + V + "px)"
			});
			this.animate(Z, {
				transform: "translateY(0)"
			},
			Y, aa)
		} else {
			this.set(W, {
				top: "+=" + V
			});
			this.animate(Z, {
				top: "-=" + V
			},
			Y, aa)
		}
	};
	P.prototype.set = function (Y, X) {
		var W = Y.position().top;
		if (y.support.backgroundSize) {
			this.setBgImage(this._$el, Y)
		} else {
			this.setImage(this._$el, Y)
		}
		var V = this._$el.parent().height();
		this._$el.each(y.proxy(function (ad, aa) {
			var Z = Math.min(this._height, V),
			ab = ad * this._height,
			ac = (W - ab) + "px";
			y(aa).css({
				top: ab + "px"
			}).height(Z);
			if (y.support.backgroundSize) {
				y(aa).css({
					backgroundPosition: Y.css("left") + " " + ac
				})
			} else {
				y(aa).find(">img").css({
					top: ac
				})
			}
			V -= Z
		},
		this));
		this._$el.css(y.extend({
			opacity: 1,
			left: 0,
			visibility: "visible",
			transform: ""
		},
		X))
	};
	s.prototype = new m();
	s.prototype.constructor = s;
	function s(Z, aa, ab, X) {
		m.call(this, Z, X);
		this._cssTransform = this._parent._cssTransform;
		this._blockArray;
		this._numRows = aa;
		this._numCols = ab;
		this._width = Math.ceil(this._parent._stageWidth / this._numCols);
		this._height = Math.ceil(this._parent._stageHeight / this._numRows);
		this._total = this._numRows * this._numCols;
		this._$el = this.create("br-block").data({
			width: this._width,
			height: this._height
		});
		var V = 0;
		this._blockArray = [];
		for (var Y = 0; Y < this._numRows; Y++) {
			this._blockArray[Y] = [];
			for (var W = 0; W < this._numCols; W++) {
				this._blockArray[Y][W] = this._$el.eq(V++)
			}
		}
	}
	s.prototype.diagonalFade = function (V, W, X, Z) {
		this.set(V, {
			opacity: 0
		});
		var Y = this.getDiagonalArray();
		if ("reverseDiagonalFade" === W) {
			Y.reverse()
		}
		this.animate(Y, {
			opacity: 1
		},
		X, Z)
	};
	s.prototype.diagonalExpand = function (V, X, Y, aa) {
		var Z = this.getDiagonalArray(),
		W = this.getExpandCSS();
		this.set(V, W.from);
		if ("reverseDiagonalExpand" === X) {
			Z.reverse()
		}
		this.animate(Z, W.to, Y, aa)
	};
	s.prototype.diagonalShift = function (W, Y, Z, ab) {
		var aa = this.getDiagonalArray(),
		V = this._width,
		X = this._height;
		if ("reverseDiagonalShift" === Y) {
			aa.reverse();
			V *= -1;
			X *= -1
		}
		if (this._cssTransform) {
			this.set(W, {
				opacity: 0,
				transform: "translate(" + V + "px, " + X + "px)"
			});
			this.animate(aa, {
				opacity: 1,
				transform: "translate(0, 0)"
			},
			Z, ab)
		} else {
			this.set(W, {
				opacity: 0,
				left: "+=" + V,
				top: "+=" + X
			});
			this.animate(aa, {
				opacity: 1,
				left: "-=" + V,
				top: "-=" + X
			},
			Z, ab)
		}
	};
	s.prototype.randomEffect = function (V, ad, W, Y) {
		var X = this._$el.toArray();
		o(X);
		var aa, ab;
		if ("blockRandomDrop" === ad) {
			var ac = this._$el.parent().height();
			if (this._cssTransform) {
				aa = {
					transform: "translateY(" + -ac + "px)"
				};
				ab = {
					transform: "translateY(0)"
				}
			} else {
				aa = {
					top: "-=" + ac
				};
				ab = {
					top: "+=" + ac
				}
			}
		} else {
			if ("blockRandomExpand" === ad) {
				var Z = this.getExpandCSS();
				aa = Z.from;
				ab = Z.to
			} else {
				aa = {
					opacity: 0
				};
				ab = {
					opacity: 1
				}
			}
		}
		this.set(V, aa);
		this.animate(X, ab, W, Y)
	};
	s.prototype.zigZag = function (V, W, X, Z) {
		this.set(V, {
			opacity: 0
		});
		var Y = this.getZigZagArray(W);
		if ("zigZagLeft" === W || "zigZagUp" === W) {
			Y.reverse()
		}
		this.animate(Y, {
			opacity: 1
		},
		X, Z)
	};
	s.prototype.spiral = function (V, W, X, Z) {
		this.set(V, {
			opacity: 0
		});
		var Y = this.getSpiralArray();
		if ("spiralOut" === W) {
			Y.reverse()
		}
		this.animate(Y, {
			opacity: 1
		},
		X, Z)
	};
	s.prototype.expand = function (V, X, Y, Z) {
		var W = this.getExpandCSS();
		this.set(V, W.from);
		this.animate(this.getDirectionalArray(X), W.to, Y, Z)
	};
	s.prototype.getExpandCSS = function () {
		if (this._cssTransform) {
			return {
				from: {
					transform: "scale(0)"
				},
				to: {
					transform: "scale(1)"
				}
			}
		} else {
			return {
				from: {
					width: 0,
					height: 0
				},
				to: {
					width: this._width + "px",
					height: this._height + "px"
				}
			}
		}
	};
	s.prototype.set = function (V, ab) {
		var ac = V.position().top,
		ai = V.position().left;
		if (y.support.backgroundSize) {
			this.setBgImage(this._$el, V)
		} else {
			this.setImage(this._$el, V)
		}
		var aj = this._$el.parent(),
		ah = aj.height();
		for (var Z = 0; Z < this._numRows; Z++) {
			var aa = aj.width(),
			ag = Math.min(this._height, ah);
			ah -= ag;
			for (var Y = 0; Y < this._numCols; Y++) {
				var W = Math.min(this._width, aa),
				ae = Z * this._height,
				X = Y * this._width,
				af = (ai - X) + "px",
				ad = (ac - ae) + "px",
				ak = this._blockArray[Z][Y];
				ak.css({
					top: ae + "px",
					left: X + "px"
				}).width(W).height(ag);
				if (y.support.backgroundSize) {
					ak.css({
						backgroundPosition: af + " " + ad
					})
				} else {
					ak.find(">img").css({
						left: af,
						top: ad
					})
				}
				aa -= W
			}
		}
		this._$el.css(y.extend({
			opacity: 1,
			visibility: "visible",
			transform: ""
		},
		ab))
	};
	s.prototype.getDiagonalArray = function () {
		var W = [];
		var X = 0,
		V = (this._numRows - 1) + (this._numCols - 1) + 1;
		while (X != V) {
			i = Math.min(this._numRows - 1, X);
			while (i >= 0) {
				j = Math.abs(i - X);
				if (j >= this._numCols) {
					break
				}
				W.push(this._blockArray[i][j]);
				i--
			}
			X++
		}
		return W
	};
	s.prototype.getZigZagArray = function (Y) {
		var X = 0,
		V = 0,
		W = true;
		var aa = [];
		if ("zigZagUp" === Y || "zigZagDown" === Y) {
			for (var Z = 0; Z < this._total; Z++) {
				aa[Z] = this._blockArray[X][V];
				W ? V++:V--;
				if (V == this._numCols || V < 0) {
					W = !W;
					V = (W ? 0 : this._numCols - 1);
					X++
				}
			}
		} else {
			for (var Z = 0; Z < this._total; Z++) {
				aa[Z] = this._blockArray[X][V];
				W ? X++:X--;
				if (X == this._numRows || X < 0) {
					W = !W;
					X = (W ? 0 : this._numRows - 1);
					V++
				}
			}
		}
		return aa
	};
	s.prototype.getDirectionalArray = function (X) {
		var Y = [];
		switch (X) {
		case "blockExpandRight":
			for (var V = 0; V < this._numCols; V++) {
				for (var W = 0; W < this._numRows; W++) {
					Y.push(this._blockArray[W][V])
				}
			}
			break;
		case "blockExpandLeft":
			for (var V = this._numCols - 1; V >= 0; V--) {
				for (var W = 0; W < this._numRows; W++) {
					Y.push(this._blockArray[W][V])
				}
			}
			break;
		case "blockExpandUp":
			for (var W = this._numRows - 1; W >= 0; W--) {
				for (var V = 0; V < this._numCols; V++) {
					Y.push(this._blockArray[W][V])
				}
			}
			break;
		default:
			Y = this._$el.toArray();
			break
		}
		return Y
	};
	s.prototype.getSpiralArray = function () {
		var Z = 0,
		Y = 0;
		var W = this._numRows - 1;
		var ab = this._numCols - 1;
		var X = 0;
		var V = ab;
		var ac = [];
		while (W >= 0 && ab >= 0) {
			var aa = 0;
			while (true) {
				ac.push(this._blockArray[Z][Y]);
				if ((++aa) > V) {
					break
				}
				switch (X) {
				case 0:
					Y++;
					break;
				case 1:
					Z++;
					break;
				case 2:
					Y--;
					break;
				case 3:
					Z--;
					break
				}
			}
			switch (X) {
			case 0:
				X = 1;
				V = (--W);
				Z++;
				break;
			case 1:
				X = 2;
				V = (--ab);
				Y--;
				break;
			case 2:
				X = 3;
				V = (--W);
				Z--;
				break;
			case 3:
				X = 0;
				V = (--ab);
				Y++;
				break
			}
		}
		return ac
	};
	function F(W, V) {
		this._options = V;
		this._stageWidth = V.width;
		this._stageHeight = V.height;
		this._rotate = V.autoPlay;
		this._cssTransition = y.support.transition ? V.cssTransition: false;
		this._cssTransform = y.support.transform && this._cssTransition;
		this._numItems;
		this._currIndex;
		this._effects = {};
		this._backward;
		this._verticalCPanel;
		this._timer;
		this._timerId = null;
		this._tooltipId = null;
		this._layerIds = [];
		this._inProgress = false;
		this._start;
		this._delay = 0;
		this._cpAlign;
		this._effectArray;
		this._startX = null;
		this._startY = null;
		this._swipeDist = null;
		this._scrolling;
		this._scrollEasing;
		this._promise;
		this._$rotator;
		this._$stage;
		this._$screen;
		this._$layers;
		this._$preloader;
		this._$cpanel;
		this._$cpWrapper;
		this._$extPanel;
		this._$thumbPanel;
		this._$list;
		this._$items;
		this._$thumbList;
		this._$thumbs;
		this._$tooltip;
		this._$currItem;
		this._$prevItem;
		this._$rotator = y(W);
		this._namespace = "." + ((typeof this._$rotator.attr("id") !== "undefined") ? this._$rotator.attr("id") : "rotator");
		this.init()
	}
	F.prototype = {
		init: function () {
			if (!this._cssTransition) {
				y.fn.transition = y.fn.animate;
				y.fn.stopTransition = y.fn.stop
			}
			this._$list = this._$rotator.find(">ul");
			if (!this._$list.hasClass("br-slides")) {
				this._$list.addClass("br-slides")
			}
			if (this._options.shuffle) {
				this.shuffleItems(this._$list)
			}
			this._$items = this._$list.children("li").addClass("br-item");
			this._numItems = this._$items.length;
			if ("random" === this._options.startIndex) {
				this._currIndex = Math.floor(Math.random() * this._numItems)
			} else {
				var V = parseInt(this._options.startIndex, 0);
				this._currIndex = (!isNaN(V) && 0 <= V && V < this._numItems) ? V: 0
			}
			if (this._numItems <= 1) {
				this._rotate = false
			}
			if (!this._options.responsive) {
				this._$rotator.width(this._stageWidth).height(this._stageHeight)
			}
			this.initStage();
			this.initItems();
			this.initCPanel();
			this.initEffects();
			if (this._options.responsive) {
				this.resize();
				y(window).bind("resize" + this._namespace, y.proxy(this.resize, this))
			}
			if (1 < this._numItems) {
				if (this._options.mousewheel) {
					this._$rotator.bind("mousewheel DOMMouseScroll", y.proxy(this.mousescroll, this))
				}
				if (this._options.keyboard) {
					y(document).bind("keyup" + this._namespace, y.proxy(this.keyControl, this))
				}
				if (this._options.pauseOnHover) {
					this._$rotator.hover(y.proxy(this.pause, this), y.proxy(function (W) {
						if (!this.onTooltip(W)) {
							this.play()
						}
					},
					this))
				}
				if (R && this._options.swipe) {
					this._$rotator.bind("touchstart", y.proxy(this.touchStart, this))
				}
			}
			if (this._numItems) {
				if (!r) {
					this.loadNextImage(this._$items.toArray())
				} else {
					this.loadAllImages()
				}
				this.loadSlide()
			}
		},
		initStage: function () {
			this.initBorder();
			this._$list.wrap('<div class="br-stage"><div class="br-screen"></div></div>');
			this._$screen = this._$list.parent();
			this._$stage = this._$screen.parent();
			this.setBackgroundColor(this._$screen, this._options.backgroundColor);
			if (typeof this._options.backgroundImage !== "undefined" && "" !== y.trim(this._options.backgroundImage)) {
				this._$screen.css({
					backgroundImage: "url(" + this._options.backgroundImage + ")",
					backgroundRepeat: this._options.backgroundRepeat,
					backgroundPosition: this._options.backgroundPosition
				})
			}
			this._$screen.append('<div class="br-effects"></div><div class="br-preloader"></div><div class="br-links"></div><div class="br-layers"></div>');
			this._$preloader = this._$screen.find(">.br-preloader");
			if (false !== this._options.timer && "none" !== this._options.timer) {
				if ("pie" === this._options.timer) {
					if (this._cssTransform) {
						this._timer = new U(this._$screen, this._options.timerAlign)
					}
				} else {
					this._timer = new v(this._$screen, this._options.timerAlign)
				}
			}
			if ("large" === this._options.navButtons && 1 < this._numItems) {
				this.initSideButtons()
			}
		},
		initBorder: function () {
			var X = ["borderWidth", "borderColor", "borderStyle", "borderRadius"];
			for (var W = 0; W < X.length; W++) {
				var V = X[W],
				Y = this._options[V];
				if (typeof Y !== "undefined") {
					this._$rotator.css(V, Y)
				}
			}
			if (0 < parseInt(this._$rotator.css("borderRightWidth"), 0)) {
				this._$rotator.css({
					backgroundColor: this._$rotator.css("borderRightColor")
				})
			}
		},
		createBorderWrapper: function () {
			var V = y("<div></div>").addClass("br-wrapper").copyBorder(this._$rotator);
			this._$rotator.css({
				borderWidth: 0,
				borderRadiusTopLeft: 0,
				borderRadiusTopRight: 0,
				borderRadiusBottomLeft: 0,
				borderRadiusBottomRight: 0
			});
			if (!this._options.responsive) {
				V.width(this._$rotator.outerWidth(true)).height(this._$rotator.outerHeight(true))
			}
			this._$rotator.wrap(V)
		},
		initSideButtons: function () {
			var V = y("<div><div></div></div>").addClass("br-side-prev").click(y.proxy(this.prevSlide, this));
			var X = y("<div><div></div></div>").addClass("br-side-next").click(y.proxy(this.nextSlide, this));
			var W = V.add(X).mousedown(C);
			this._$screen.append(W);
			if (this._options.navButtonsOnHover) {
				W.css({
					opacity: 0
				});
				this._$rotator.hover(function () {
					W.animate({
						opacity: 1
					},
					{
						duration: M,
						queue: false
					})
				},
				y.proxy(function (Y) {
					if (!this.onTooltip(Y)) {
						W.animate({
							opacity: 0
						},
						{
							duration: M,
							queue: false
						})
					}
				},
				this))
			}
		},
		initItems: function () {
			for (var X = 0; X < this._numItems; X++) {
				var ac = this._$items.eq(X),
				W = ac.children(":first"),
				V,
				Y,
				ad;
				if (W.is("a")) {
					W.addClass("br-img-link");
					V = W.find(">img");
					if (0 === V.length) {
						Y = W.attr("href");
						ad = E(W.text(), "")
					}
					ac.data("imgurl", W.attr("href")).append(y('<img alt=""/>').addClass("br-main-img"))
				} else {
					V = ac.find(">img:not(.tt-img):first").addClass("br-main-img")
				}
				if (V.length) {
					if (typeof V.data("thumb") !== "undefined") {
						Y = V.data("thumb")
					} else {
						Y = V.attr("src")
					}
					ad = E(V.attr("title"), "");
					V.removeAttr("title")
				}
				if ("image" === this._options.tooltip) {
					if (0 === ac.find(">img.tt-img").length) {
						ac.append(y('<img alt=""/>').addClass("tt-img").attr("src", Y))
					}
				}
				var ab = ac.data("link");
				if (typeof ab !== "undefined" && "" !== y.trim(ab)) {
					var aa = y("<a></a>").addClass("br-main-link").attr("href", ab),
					Z = ac.data("target");
					if (typeof Z !== "undefined") {
						aa.attr("target", Z)
					}
					if (this._options.pauseOnInteraction) {
						aa.click(y.proxy(this.pause, this))
					}
					this._$screen.find(">.br-links").append(aa);
					ac.data("linkEl", aa)
				}
				this.setShorthandData(ac, "transition", ["effect", "duration", "easing", "delay"]);
				ac.data({
					caption: ad,
					thumburl: Y,
					ready: false,
					effect: E(ac.data("effect"), this._options.effect),
					duration: J(ac.data("duration"), this._options.duration),
					easing: this.checkEasing(E(ac.data("easing"), this._options.easing)),
					delay: J(ac.data("delay"), this._options.delay)
				});
				this.initLayer(ac)
			}
			this._$layers = this._$screen.find(">.br-layers").children()
		},
		initCPanel: function () {
			this._$cpanel = y("<div></div>").addClass("br-cpanel");
			this._$rotator.append(this._$cpanel);
			this._cpAlign = E(T[this._options.cpanelAlign], T.bottom);
			this._verticalCPanel = ("left" === this._cpAlign[0] || "right" === this._cpAlign[0]);
			this.initThumbnails();
			this.initButtons();
			var ad = this._$cpanel.children();
			if (ad.length) {
				this._$cpanel.wrap('<div class="br-cpanel-wrapper"></div>');
				this._$cpWrapper = this._$cpanel.parent();
				if (this._verticalCPanel) {
					var Y = 0,
					ab = Math.max.apply(null, ad.map(function () {
						return y(this).outerWidth(true)
					}).get()),
					Z = 0,
					V = 0;
					ad.each(function () {
						y(this).css({
							left: Math.floor((ab - y(this).outerWidth(true)) / 2)
						});
						var ae = y(this).outerHeight(true);
						if (y(this).data("front")) {
							y(this).css({
								top: Z
							});
							Z += ae
						} else {
							y(this).css({
								bottom: V
							});
							V += ae
						}
						Y += ae
					});
					this._$cpanel.css({
						width: ab,
						height: Y
					});
					if ("top" === this._cpAlign[1]) {
						this._$cpWrapper.css({
							top: 0
						})
					} else {
						if ("bottom" === this._cpAlign[1]) {
							this._$cpWrapper.css({
								bottom: 0
							})
						} else {
							this._$cpWrapper.css({
								top: "50%"
							});
							this._$cpanel.css({
								top: -this._$cpanel.outerHeight(true) / 2
							})
						}
					}
					if (this._options.cpanelOutside) {
						this.setOutsideVerticalCPanel()
					} else {
						this.setInsideCPanel()
					}
					if (false !== this._options.thumbnails) {
						this._$cpanel.data({
							margin: this._$cpanel.outerHeight(true) - this._$cpanel.height(),
							buttonsSize: this._$cpanel.height() - ad.filter(".br-thumbnails").height()
						});
						if (this._options.responsive) {
							this._$rotator.bind(b, y.proxy(this.resizeVerticalCPanel, this));
							this.initVerticalScroll()
						} else {
							if (this._$cpanel.outerHeight(true) > this._stageHeight) {
								this.resizeVerticalCPanel();
								this.initVerticalScroll()
							}
						}
					}
				} else {
					var X = 0,
					ac = Math.max.apply(null, ad.map(function () {
						return y(this).outerHeight(true)
					}).get()),
					W = 0,
					aa = 0;
					ad.each(function () {
						y(this).css({
							top: Math.floor((ac - y(this).outerHeight(true)) / 2)
						});
						var ae = y(this).outerWidth(true);
						if (y(this).data("front")) {
							y(this).css({
								left: W
							});
							W += ae
						} else {
							y(this).css({
								right: aa
							});
							aa += ae
						}
						X += ae
					});
					this._$cpanel.css({
						width: X,
						height: ac
					});
					if ("left" === this._cpAlign[1]) {
						this._$cpWrapper.css({
							left: 0
						})
					} else {
						if ("right" === this._cpAlign[1]) {
							this._$cpWrapper.css({
								right: 0
							})
						} else {
							this._$cpWrapper.css({
								left: "50%"
							});
							this._$cpanel.css({
								left: -this._$cpanel.outerWidth(true) / 2
							})
						}
					}
					if (this._options.cpanelOutside) {
						this.setOutsideHorizontalCPanel()
					} else {
						this.setInsideCPanel()
					}
					if (false !== this._options.thumbnails) {
						this._$cpanel.data({
							margin: this._$cpanel.outerWidth(true) - this._$cpanel.width(),
							buttonsSize: this._$cpanel.width() - ad.filter(".br-thumbnails").width()
						});
						if (this._options.responsive) {
							this._$rotator.bind(b, y.proxy(this.resizeHorizontalCPanel, this));
							this.initHorizontalScroll()
						} else {
							if (this._$cpanel.outerWidth(true) > this._stageWidth) {
								this.resizeHorizontalCPanel();
								this.initHorizontalScroll()
							}
						}
					}
				}
				this._$cpanel.css({
					visibility: "visible"
				})
			} else {
				this._$cpanel.remove()
			}
		},
		setInsideCPanel: function () {
			this._$cpWrapper.css(this._cpAlign[0], 0);
			if (this._options.cpanelOnHover) {
				this._$cpanel.css({
					opacity: 0
				});
				this._$rotator.hover(y.proxy(function () {
					this._$cpanel.animate({
						opacity: 1
					},
					{
						duration: M,
						queue: false
					})
				},
				this), y.proxy(function (V) {
					if (!this.onTooltip(V)) {
						this._$cpanel.animate({
							opacity: 0
						},
						{
							duration: M,
							queue: false
						})
					}
				},
				this))
			}
		},
		setOutsideHorizontalCPanel: function () {
			this._$cpWrapper.wrap('<div class="br-ext-cp"></div>');
			this._$extPanel = this._$cpWrapper.parent().prepend('<div class="br-ext-bg"></div>');
			var W = this._$cpWrapper.height(),
			X,
			V;
			if ("top" === this._cpAlign[0]) {
				X = "marginTop";
				V = "top"
			} else {
				X = "marginBottom";
				V = "bottom"
			}
			this._$rotator.css(X, W).css({
				overflow: "visible"
			});
			this._$extPanel.css({
				left: 0,
				width: "100%",
				height: W
			}).css(V, -W);
			this.createBorderWrapper();
			this.setBackgroundColor(this._$extPanel.find(">.br-ext-bg"), this._options.cpanelColor)
		},
		setOutsideVerticalCPanel: function () {
			this._$cpWrapper.wrap('<div class="br-ext-cp"></div>');
			this._$extPanel = this._$cpWrapper.parent().prepend('<div class="br-ext-bg"></div>');
			var W = this._$cpWrapper.width(),
			X,
			V;
			if ("left" === this._cpAlign[0]) {
				X = "marginLeft";
				V = "left"
			} else {
				X = "marginRight";
				V = "right"
			}
			this._$rotator.css(X, W).css({
				overflow: "visible"
			});
			this._$extPanel.css({
				top: 0,
				width: W,
				height: "100%"
			}).css(V, -W);
			this.createBorderWrapper();
			this.setBackgroundColor(this._$extPanel.find(">.br-ext-bg"), this._options.cpanelColor)
		},
		setBackgroundColor: function (V, W) {
			if (typeof W !== "undefined") {
				if ("" === y.trim(W)) {
					W = "transparent"
				}
				V.css({
					backgroundColor: W
				})
			}
		},
		initButtons: function () {
			var W = {
				width: this._options.buttonWidth,
				height: this._options.buttonHeight,
				margin: this._options.buttonMargin
			},
			X,
			V,
			Y;
			if (this._options.playButton && 1 < this._numItems) {
				X = y("<div><div></div></div>");
				X.addClass("br-play-button").css(W).toggleClass("br-pause", this._rotate).click(y.proxy(this.togglePlay, this)).mousedown(C);
				this._$cpanel.prepend(X)
			}
			if ((true === this._options.navButtons || "small" === this._options.navButtons) && 1 < this._numItems) {
				V = y("<div><div></div></div>").addClass("br-prev-button").css(W).toggleClass("br-up", this._verticalCPanel).click(y.proxy(this.prevSlide, this)).mousedown(C);
				Y = y("<div><div></div></div>").addClass("br-next-button").css(W).toggleClass("br-down", this._verticalCPanel).click(y.proxy(this.nextSlide, this)).mousedown(C);
				if (typeof X !== "undefined") {
					X.before(Y).after(V)
				} else {
					V.data("front", true);
					this._$cpanel.append(V).prepend(Y)
				}
			}
		},
		initThumbnails: function () {
			var Y = this._options.thumbnails;
			if (false !== Y && "none" !== Y) {
				this._$thumbPanel = y("<div></div>").addClass("br-thumbnails");
				this._$thumbList = y("<ul></ul>");
				this._$thumbPanel.append(this._$thumbList);
				this._$cpanel.append(this._$thumbPanel);
				for (var W = 0; W < this._numItems; W++) {
					if ("number" === Y) {
						this._$thumbList.append("<li>" + (W + 1) + "</li>")
					} else {
						if ("text" === Y) {
							this._$thumbList.append("<li>" + this._$items.eq(W).data("caption") + "</li>")


						} else {
							if ("image" === Y) {
								var X = y("<li></li>").addClass("br-thumb-img"),
								V = y('<img alt=""/>').css({
									opacity: 0
								});
								if (!r) {
									X.append("<div></div>")
								}
								X.prepend(V).appendTo(this._$thumbList);
								V.one("load", y.proxy(function (Z) {
									this.fillContent(y(Z.currentTarget), this._options.thumbWidth, this._options.thumbHeight);
									y(Z.currentTarget).animate({
										opacity: 1
									},
									M)
								},
								this)).attr("src", this._$items.eq(W).data("thumburl"));
								if (V[0].complete || "complete" === V[0].readyState) {
									V.trigger("load")
								}
							} else {
								this._$thumbList.append(y("<li></li>").toggleClass("br-bullet", "bullet" === Y))
							}
						}
					}
				}
				this._$thumbs = this._$thumbList.children("li");
				if ("bullet" !== Y) {
					this._$thumbs.css({
						width: this._options.thumbWidth,
						height: this._options.thumbHeight,
						margin: this._options.thumbMargin,
						lineHeight: this._options.thumbHeight + "px"
					})
				}
				if (this._options.selectOnHover) {
					this._$thumbs.mouseenter(y.proxy(this.selectSlide, this))
				} else {
					this._$thumbs.click(y.proxy(this.selectSlide, this)).mousedown(C)
				}
				if (this._verticalCPanel) {
					this._$thumbList.css({
						width: this._$thumbs.outerWidth(true),
						height: this._numItems * this._$thumbs.outerHeight(true)
					})
				} else {
					this._$thumbList.css({
						width: this._numItems * this._$thumbs.outerWidth(true),
						height: this._$thumbs.outerHeight(true)
					})
				}
				this.initTooltip()
			} else {
				this._options.thumbnails = false
			}
		},
		initLayer: function (W) {
			var V = W.children(":not(.tt-html, img.tt-img, img.br-main-img, a.br-img-link)").addClass("br-layer");
			W.data("layers", V);
			this._$screen.find(">.br-layers").append(V);
			V.each(y.proxy(function (ab, aa) {
				var Z = y(aa),
				X = "marginTop",
				Y = "marginLeft";
				if ("auto" === Z[0].style.width && "auto" === Z[0].style.height) {
					Z.css("white-space", "nowrap")
				}
				if (!isNaN(parseInt(Z[0].style.top, 0))) {
					if (!D(Z[0].style.top)) {
						Z.css({
							top: (c(Z.css("top"), 0) / this._stageHeight * 100) + "%"
						})
					}
					Z.css({
						bottom: "auto"
					})
				} else {
					if (!isNaN(parseInt(Z[0].style.bottom, 0))) {
						if (!D(Z[0].style.bottom)) {
							Z.css({
								bottom: (c(Z.css("bottom"), 0) / this._stageHeight * 100) + "%"
							})
						}
						Z.css({
							top: "auto"
						});
						X = "marginBottom"
					}
				}
				if (!isNaN(parseInt(Z[0].style.left, 0))) {
					if (!D(Z[0].style.left)) {
						Z.css({
							left: (c(Z.css("left"), 0) / this._stageWidth * 100) + "%"
						})
					}
					Z.css({
						right: "auto"
					})
				} else {
					if (!isNaN(parseInt(Z[0].style.right, 0))) {
						if (!D(Z[0].style.right)) {
							Z.css({
								right: (c(Z.css("right"), 0) / this._stageWidth * 100) + "%"
							})
						}
						Z.css({
							left: "auto"
						});
						Y = "marginRight"
					}
				}
				this.setShorthandData(Z, "transition", ["effect", "duration", "easing", "delay"]);
				this.setShorthandData(Z, "transitionOut", ["effectOut", "durationOut", "easingOut", "delayOut"]);
				Z.data({
					width: "auto" === Z[0].style.width ? "auto": Z.width(),
					height: "auto" === Z[0].style.height ? "auto": Z.height(),
					opacity: x(Z.css("opacity"), 1),
					padTop: c(Z.css("paddingTop"), 0),
					padBottom: c(Z.css("paddingBottom"), 0),
					padLeft: c(Z.css("paddingLeft"), 0),
					padRight: c(Z.css("paddingRight"), 0),
					borderTop: c(Z.css("borderTopWidth"), 0),
					borderBottom: c(Z.css("borderBottomWidth"), 0),
					borderLeft: c(Z.css("borderLeftWidth"), 0),
					borderRight: c(Z.css("borderRightWidth"), 0),
					fontSize: parseInt(Z.css("fontSize"), 0),
					lineHeight: parseInt(Z.css("lineHeight"), 0),
					verticalMargin: X,
					horizontalMargin: Y,
					effect: this.getEffect(E(Z.data("effect"), this._options.layerEffect)),
					duration: J(Z.data("duration"), this._options.layerDuration),
					easing: this.checkEasing(E(Z.data("easing"), this._options.layerEasing)),
					delay: G(Z.data("delay"), this._options.layerDelay),
					effectOut: this.getEffect(E(Z.data("effectOut"), this._options.layerEffectOut)),
					durationOut: J(Z.data("durationOut"), this._options.layerDurationOut),
					easingOut: this.checkEasing(E(Z.data("easingOut"), this._options.layerEasingOut)),
					delayOut: G(Z.data("delayOut"), this._options.layerDelayOut)
				})
			},
			this))
		},
		setShorthandData: function (Z, X, aa) {
			var W = Z.data(X);
			if (typeof W !== "undefined") {
				var V = W.split(" ", aa.length);
				for (var Y = 0; Y < aa.length; Y++) {
					if (typeof V[Y] !== "undefined") {
						Z.data(aa[Y], V[Y])
					}
				}
				Z.removeData(X)
			}
		},
		initEffects: function () {
			this._$rotator.one("createEffect.vCover", y.proxy(function () {
				this._effects.vCover = new S(this, 1, 0)
			},
			this)).one("createEffect.hCover", y.proxy(function () {
				this._effects.hCover = new P(this, 1, 0)
			},
			this)).one("createEffect.blocks", y.proxy(function () {
				this._effects.blocks = new s(this, this._options.blockRows, this._options.blockCols, this._options.blockDelay)
			},
			this)).one("createEffect.vSlices", y.proxy(function () {
				this._effects.vSlices = new S(this, this._options.verticalSlices, this._options.verticalSliceDelay)
			},
			this)).one("createEffect.hSlices", y.proxy(function () {
				this._effects.hSlices = new P(this, this._options.horizontalSlices, this._options.horizontalSliceDelay)
			},
			this)).one("createEffect.vSlide", y.proxy(function () {
				this._effects.vSlide = new I(this, "vertical")
			},
			this)).one("createEffect.hSlide", y.proxy(function () {
				this._effects.hSlide = new I(this, "horizontal")
			},
			this));
			var X = this._$items.map(function () {
				return y(this).data("effect")
			}).get();
			X[X.length] = this._options.effect;
			for (var V = 0; V < X.length; V++) {
				var W = X[V];
				if ("random" === W) {
					this._effectArray = [];
					y.each(p, y.proxy(function (Y, Z) {
						this._effectArray[this._effectArray.length] = Y
					},
					this));
					this._$rotator.trigger("createEffect");
					break
				}
				if (typeof p[W] !== "undefined") {
					this._$rotator.trigger("createEffect." + p[W][0])
				}
			}
			this._$rotator.unbind("createEffect")
		},
		initTooltip: function () {
			if (false !== this._options.tooltip && "none" !== this._options.tooltip) {
				this._$tooltip = y("<div></div>").addClass("br-tt br-tt-" + this._cpAlign[0]).append('<div class="br-tt-tip"></div><div class="br-tt-content"></div>');
				var V = this._$tooltip.find(">.br-tt-content").width(this._options.tooltipWidth).height(this._options.tooltipHeight);
				y("body").prepend(this._$tooltip);
				if ("image" === this._options.tooltip) {
					this._$items.each(y.proxy(function (aa, Y) {
						var X = y(Y).find(">img.tt-img"),
						W = X.clone();
						V.append(W);
						var Z = this._$thumbs.eq(aa);
						Z.hover(y.proxy(function () {
							this._$tooltip.stop(true, true).find("img").hide().eq(aa).show();
							this.displayTooltip(Z)
						},
						this), y.proxy(this.hideTooltip, this));
						X.one("load", y.proxy(function () {
							this.fillContent(X, this._options.tooltipWidth, this._options.tooltipHeight);
							W.css({
								visibility: "visible",
								top: X.css("top"),
								left: X.css("left")
							}).width(X.width()).height(X.height());
							X.remove()
						},
						this));
						if (X[0].complete || "complete" === X[0].readyState) {
							X.trigger("load")
						}
					},
					this))
				} else {
					this._$items.each(y.proxy(function (ac, aa) {
						var X, Y = y(aa).find(">.tt-html");
						if (Y.length && "" !== Y.html()) {
							X = Y.html()
						} else {
							X = y(aa).data("caption")
						}
						if (typeof X !== "undefined" && "" !== X) {
							var ab = this._$thumbs.eq(ac);
							if ("auto" === this._options.tooltipWidth && "auto" === this._options.tooltipHeight) {
								V.html(X);
								var Z = V.width() + 1,
								W = V.height() + 1;
								V.html("");
								ab.bind(d, y.proxy(function () {
									V.width(Z).height(W)
								},
								this))
							}
							ab.hover(y.proxy(function () {
								this._$tooltip.stop(true, true);
								ab.trigger(d);
								V.html(X);
								this.displayTooltip(ab)
							},
							this), y.proxy(this.hideTooltip, this))
						}
					},
					this))
				}
				if (q) {
					this._$tooltip.mouseleave(y.proxy(function (W) {
						if (document.elementFromPoint && !y(document.elementFromPoint(W.clientX, W.clientY)).closest(".banner-rotator").is(this._$rotator)) {
							this._$rotator.trigger("mouseleave")
						}
					},
					this))
				}
			}
		},
		displayTooltip: function (Y) {
			var V = this._options.cpanelOutside ? this._$extPanel: Y,
			X,
			W;
			if (this._verticalCPanel) {
				W = V.offset().left;
				if ("left" === this._cpAlign[0]) {
					W += V.outerWidth()
				} else {
					W -= this._$tooltip.outerWidth(true)
				}
				X = Y.offset().top - (this._$tooltip.outerHeight(true) - Y.outerHeight()) / 2
			} else {
				X = V.offset().top;
				if ("top" === this._cpAlign[0]) {
					X += V.outerHeight()
				} else {
					X -= this._$tooltip.outerHeight(true)
				}
				W = Y.offset().left - (this._$tooltip.outerWidth(true) - Y.outerWidth()) / 2
			}
			this._tooltipId = setTimeout(y.proxy(function () {
				this._$tooltip.css({
					opacity: 0,
					top: X,
					left: W
				}).show().animate({
					opacity: 1
				},
				M)
			},
			this), this._options.tooltipDelay)
		},
		hideTooltip: function () {
			clearTimeout(this._tooltipId);
			this._$tooltip.stop(true).animate({
				opacity: 0
			},
			400, function () {
				y(this).hide()
			})
		},
		selectSlide: function (W) {
			if (this._options.pauseOnInteraction) {
				this.pause()
			}
			if (!this._inProgress) {
				var V = y(W.currentTarget).index();
				if (V != this._currIndex) {
					if (this._options.layerOutSync) {
						this.loadDeferred(y.proxy(function () {
							this.select_slide(V)
						},
						this))
					} else {
						this.select_slide(V)
					}
				}
			}
		},
		select_slide: function (V) {
			this._backward = V < this._currIndex;
			this._currIndex = V;
			this.loadSlide()
		},
		prevSlide: function () {
			if (this._options.pauseOnInteraction) {
				this.pause()
			}
			if (!this._inProgress) {
				if (this._options.layerOutSync) {
					this.loadDeferred(y.proxy(function () {
						this.prev_slide()
					},
					this))
				} else {
					this.prev_slide()
				}
			}
		},
		prev_slide: function () {
			this._$rotator.trigger(N);
			this._options.onPrev.call(this);
			this._backward = true;
			this._currIndex = (this._currIndex > 0) ? (this._currIndex - 1) : (this._numItems - 1);
			this.loadSlide()
		},
		nextSlide: function () {
			if (this._options.pauseOnInteraction) {
				this.pause()
			}
			if (!this._inProgress) {
				if (this._options.layerOutSync) {
					this.loadDeferred(y.proxy(function () {
						this.next_slide()
					},
					this))
				} else {
					this.next_slide()
				}
			}
		},
		next_slide: function () {
			this._$rotator.trigger(n);
			this._options.onNext.call(this);
			this._backward = false;
			this._currIndex = (this._currIndex < this._numItems - 1) ? (this._currIndex + 1) : 0;
			this.loadSlide()
		},
		rotateSlide: function () {
			if (!this._inProgress) {
				if (this._options.layerOutSync) {
					this.loadDeferred(y.proxy(function () {
						this.rotate_slide()
					},
					this))
				} else {
					this.rotate_slide()
				}
			}
		},
		rotate_slide: function () {
			this._backward = false;
			this._currIndex = (this._currIndex < this._numItems - 1) ? (this._currIndex + 1) : 0;
			this.loadSlide()
		},
		togglePlay: function () {
			if (this._rotate) {
				this.pause()
			} else {
				this.play()
			}
		},
		play: function () {
			if (!this._rotate) {
				this._rotate = true;
				this._$cpanel.find(">.br-play-button").addClass("br-pause");
				if (!this._inProgress) {
					this.resumeTimer()
				}
				this._$rotator.trigger(L);
				this._options.onPlay.call(this)
			}
		},
		pause: function () {
			if (this._rotate) {
				this._rotate = false;
				this._$cpanel.find(">.br-play-button").removeClass("br-pause");
				if (!this._inProgress) {
					this.pauseTimer()
				}
				this._$rotator.trigger(t);
				this._options.onPause.call(this)
			}
		},
		displayLayers: function () {
			this.stopLayers();
			this._layerIds = [];
			this._$currItem.data("layers").each(y.proxy(function (W, V) {
				this._layerIds.push(setTimeout(y.proxy(function () {
					this.animateLayer(y(V))
				},
				this), y(V).data("delay")))
			},
			this))
		},
		animateLayer: function (V) {
			V.stopTransition(true, true);
			var W = V.data(),
			Y = {},
			X = {};
			V.css({
				opacity: W.opacity,
				margin: 0,
				transform: ""
			}).show();
			switch (W.effect) {
			case "fade":
				Y = {
					opacity: 0
				};
				X = {
					opacity: W.opacity
				};
				break;
			case "moveDown":
				Y[W.verticalMargin] = this.getVerticalOffset(V, true);
				X[W.verticalMargin] = 0;
				break;
			case "moveUp":
				Y[W.verticalMargin] = this.getVerticalOffset(V, false);
				X[W.verticalMargin] = 0;
				break;
			case "moveRight":
				Y[W.horizontalMargin] = this.getHorizontalOffset(V, true);
				X[W.horizontalMargin] = 0;
				break;
			case "moveLeft":
				Y[W.horizontalMargin] = this.getHorizontalOffset(V, false);
				X[W.horizontalMargin] = 0;
				break;
			case "zoomIn":
				Y = {
					transform: "scale(0)",
					opacity: 0
				};
				X = {
					transform: "scale(1)",
					opacity: W.opacity
				};
				break;
			case "zoomOut":
				Y = {
					transform: "scale(2)",
					opacity: 0
				};
				X = {
					transform: "scale(1)",
					opacity: W.opacity
				};
				break;
			case "flipDown":
				Y = {
					transform: "perspective(400px) rotateX(90deg)"
				};
				X = {
					transform: "perspective(400px) rotateX(0deg)"
				};
				break;
			case "flipUp":
				Y = {
					transform: "perspective(400px) rotateX(-90deg)"
				};
				X = {
					transform: "perspective(400px) rotateX(0deg)"
				};
				break;
			case "flipRight":
				Y = {
					transform: "perspective(400px) rotateY(-90deg)"
				};
				X = {
					transform: "perspective(400px) rotateY(0deg)"
				};
				break;
			case "flipLeft":
				Y = {
					transform: "perspective(400px) rotateY(90deg)"
				};
				X = {
					transform: "perspective(400px) rotateY(0deg)"
				};
				break;
			case "slideDown":
			case "slideUp":
			case "slideRight":
			case "slideLeft":
				this.slideEffect(V, {
					effect: W.effect,
					duration: W.duration,
					easing: W.easing,
					effectOut: false
				});
				this.deferLayerOut(V);
				return;
			default:
				this.deferLayerOut(V);
				return
			}
			V.css(Y).transition(X, W.duration, W.easing);
			this.deferLayerOut(V)
		},
		deferLayerOut: function (V) {
			var W = V.data("delayOut");
			if (typeof W !== "undefined" && 0 < W) {
				V.promise().done(y.proxy(function () {
					this._layerIds.push(setTimeout(y.proxy(function () {
						this.animateLayerOut(V)
					},
					this), W))
				},
				this))
			}
		},
		animateLayerOut: function (V) {
			V.stopTransition(true, true);
			var W = V.data(),
			Y = {},
			X = {};
			switch (W.effectOut) {
			case "fade":
				Y = {
					opacity: W.opacity
				};
				X = {
					opacity: 0
				};
				break;
			case "moveDown":
				Y[W.verticalMargin] = 0;
				X[W.verticalMargin] = this.getVerticalOffset(V, false);
				break;
			case "moveUp":
				Y[W.verticalMargin] = 0;
				X[W.verticalMargin] = this.getVerticalOffset(V, true);
				break;
			case "moveRight":
				Y[W.horizontalMargin] = 0;
				X[W.horizontalMargin] = this.getHorizontalOffset(V, false);
				break;
			case "moveLeft":
				Y[W.horizontalMargin] = 0;
				X[W.horizontalMargin] = this.getHorizontalOffset(V, true);
				break;
			case "zoomIn":
				Y = {
					transform: "scale(1)",
					opacity: W.opacity
				};
				X = {
					transform: "scale(2)",
					opacity: 0
				};
				break;
			case "zoomOut":
				Y = {
					transform: "scale(1)",
					opacity: W.opacity
				};
				X = {
					transform: "scale(0)",
					opacity: 0
				};
				break;
			case "flipDown":
				Y = {
					transform: "perspective(400px) rotateX(0deg)"
				};
				X = {
					transform: "perspective(400px) rotateX(-90deg)"
				};
				break;
			case "flipUp":
				Y = {
					transform: "perspective(400px) rotateX(0deg)"
				};
				X = {
					transform: "perspective(400px) rotateX(90deg)"
				};
				break;
			case "flipRight":
				Y = {
					transform: "perspective(400px) rotateY(0deg)"
				};
				X = {
					transform: "perspective(400px) rotateY(90deg)"
				};
				break;
			case "flipLeft":
				Y = {
					transform: "perspective(400px) rotateY(0deg)"
				};
				X = {
					transform: "perspective(400px) rotateY(-90deg)"
				};
				break;
			case "slideDown":
			case "slideUp":
			case "slideRight":
			case "slideLeft":
				this.slideEffect(V, {
					effect: W.effectOut,
					duration: W.durationOut,
					easing: W.easingOut,
					effectOut: true,
					complete: function () {
						y(this).hide()
					}
				});
				V.data({
					promise: V.promise()
				});
				return;
			default:
				V.hide();
				return
			}
			V.css(Y).transition(X, W.durationOut, W.easingOut, function () {
				y(this).hide()
			}).data({
				promise: V.promise()
			})
		},
		slideEffect: function (X, aa) {
			var Y = aa.effect,
			ac = {},
			ab = {},
			Z = this,
			V, W;
			if ("slideLeft" === Y || "slideRight" === Y) {
				V = "left";
				W = X.outerWidth(true)
			} else {
				V = "top";
				W = X.outerHeight(true)
			}
			if (aa.effectOut) {
				ac[V] = 0;
				ab[V] = ("slideLeft" === Y || "slideUp" === Y) ? -W: W
			} else {
				ac[V] = ("slideRight" === Y || "slideDown" === Y) ? -W: W;
				ab[V] = 0
			}
			this.createWrapper(X);
			X.css(ac).transition(ab, aa.duration, aa.easing, function () {
				Z.removeWrapper(X);
				if (y.isFunction(aa.complete)) {
					aa.complete.call(this)
				}
			})
		},
		createWrapper: function (W) {
			this.saveStyle(W);
			var V = {
				width: W.width(),
				height: W.height()
			},
			X = y("<div></div>");
			X.addClass("br-effect-wrapper").css({
				position: W.css("position"),
				"float": W.css("float"),
				width: W.outerWidth(true),
				height: W.outerHeight(true),
				zIndex: W.css("zIndex"),
				top: W[0].style.top,
				left: W[0].style.left,
				bottom: W[0].style.bottom,
				right: W[0].style.right
			});
			W.wrap(X).css({
				display: "block",
				position: "relative",
				top: 0,
				left: 0,
				bottom: "auto",
				right: "auto"
			}).css(V)
		},
		removeWrapper: function (V) {
			this.restoreStyle(V);
			if (V.parent().is(".br-effect-wrapper")) {
				V.unwrap()
			}
		},
		saveStyle: function (W) {
			var Y = {},
			X = ["display", "position", "top", "left", "bottom", "right", "width", "height"];
			for (var V = 0; V < X.length; V++) {
				Y[X[V]] = W[0].style[X[V]]
			}
			W.data("effectdata", Y)
		},
		restoreStyle: function (V) {
			y.each(V.data("effectdata"), function (W, X) {
				if (typeof X === "undefined") {
					X = ""
				}
				V.css(W, X)
			})
		},
		stopLayers: function () {
			while (this._layerIds.length) {
				clearTimeout(this._layerIds.pop())
			}
			this._$layers.stopTransition(true, true)
		},
		clearLayers: function (W) {
			this.stopLayers();
			var V = this._$layers.filter(":visible");
			if (W) {
				V.each(y.proxy(function (Y, X) {
					this.animateLayerOut(y(X))
				},
				this))
			} else {
				V.hide()
			}
		},
		loadDeferred: function (X) {
			if (typeof this._promise === "undefined" || "pending" !== this._promise.state()) {
				this._$items.find(">img.br-main-img").unbind("load.display");
				this.resetTimer();
				while (this._layerIds.length) {
					clearTimeout(this._layerIds.pop())
				}
				var V = this._$layers.filter(":visible");
				if (V.length) {
					var W = [];
					V.each(y.proxy(function (aa, Z) {
						var Y = y(Z);
						if (typeof Y.data("promise") === "undefined" || "pending" !== Y.data("promise").state()) {
							this.animateLayerOut(Y)
						}
						W[aa] = Y.data("promise")
					},
					this));
					this._promise = y.when.apply(null, W).done(function () {
						X.call(this)
					});
					V.removeData("promise")
				} else {
					X.call(this)
				}
			}
		},
		loadSlide: function () {
			this._$items.find(">img.br-main-img").unbind("load.display");
			this._$screen.find(">a.br-main-link").hide();
			this.resetTimer();
			this.clearLayers(true);
			y.each(this._effects, function (X, Y) {
				Y.clear()
			});
			if (0 === this._currIndex) {
				this._$rotator.trigger(H);
				this._options.onFirstSlide.call(this)
			}
			if ((this._numItems - 1) === this._currIndex) {
				this._$rotator.trigger(w);
				this._options.onLastSlide.call(this);
				if (this._options.playOnce) {
					this.pause()
				}
			}
			this._$rotator.trigger(h);
			this._options.onSlideChange.call(this);
			if (false !== this._options.thumbnails) {
				this._$thumbs.removeClass("br-curr").eq(this._currIndex).addClass("br-curr");
				this._$rotator.trigger(B)
			}
			var V = this._$items.eq(this._currIndex);
			if (V.data("ready")) {
				this.displayContent(V)
			} else {
				this._$preloader.show();
				var W = V.find(">img.br-main-img");
				W.one("load.display", y.proxy(function () {
					if (!V.data("ready")) {
						this.processImage(V)
					}
					this.displayContent(V)
				},
				this));
				if (typeof W.attr("src") === "undefined" || "" === W.attr("src")) {
					W.attr("src", V.data("imgurl"))
				}
				if (W[0].complete || "complete" === W[0].readyState) {
					W.trigger("load")
				}
			}
		},
		displayContent: function (V) {
			this._$preloader.hide();
			this._inProgress = true;
			this._$prevItem = this._$currItem;
			this._$currItem = V;
			var Z = this._$currItem.data();
			if (typeof Z.linkEl !== "undefined") {
				Z.linkEl.show()
			}
			if (!this._options.layerSync) {
				this.displayLayers()
			}
			if (typeof this._$prevItem === "undefined" || this._$prevItem.index() == this._$currItem.index()) {
				this.displayCurrent();
				return
			}
			var Y = Z.effect;
			if ("random" === Y) {
				Y = this._effectArray[Math.floor(Math.random() * this._effectArray.length)]
			}
			if (typeof p[Y] !== "undefined") {
				var W = p[Y][0];
				var X = p[Y][1];
				this._effects[W][X](this._$currItem.find(">img.br-main-img"), Y, Z.duration, Z.easing)
			} else {
				this.displayCurrent()
			}
		},
		displayCurrent: function () {
			this._$rotator.trigger(Q);
			this._options.onSlideComplete.call(this);
			if (this._options.layerSync) {
				this.displayLayers()
			}
			this._$items.css({
				visibility: "hidden"
			});
			this._$currItem.css({
				visibility: "visible"
			});
			this.startTimer();
			this._inProgress = false
		},
		loadImage: function (W) {
			var V = y.Deferred(),
			X = W.find(">img.br-main-img");
			X.one("load", y.proxy(function () {
				if (!W.data("ready")) {
					this.processImage(W)
				}
				V.resolve()
			},
			this)).error(function () {
				V.reject()
			});
			if (typeof X.attr("src") === "undefined" || "" === X.attr("src")) {
				X.attr("src", W.data("imgurl"))
			}
			if (X[0].complete || "complete" === X[0].readyState) {
				X.trigger("load")
			}
			return V
		},
		loadNextImage: function (V, W) {
			if (V.length) {
				y.when(this.loadImage(y(V.pop()))).always(y.proxy(function () {
					this.loadNextImage(V, W)
				},
				this))

			} else {
				if (y.isFunction(W)) {
					W.call(this)
				}
			}
		},
		loadAllImages: function () {
			var V = 0;
			var W = setInterval(y.proxy(function () {
				if (V < this._numItems) {
					var X = this._$items.eq(V++),
					Y = X.find(">img.br-main-img");
					Y.one("load", y.proxy(function () {
						if (!X.data("ready")) {
							this.processImage(X)
						}
					},
					this));
					if (typeof Y.attr("src") === "undefined" || "" === Y.attr("src")) {
						Y.attr("src", X.data("imgurl"))
					}
					if (Y[0].complete || "complete" === Y[0].readyState) {
						Y.trigger("load")
					}
				} else {
					clearInterval(W)
				}
			},
			this), 100)
		},
		processImage: function (ac) {
			var V = ac.find(">img.br-main-img"),
			Y = E(ac.data("imagePosition"), this._options.imagePosition),
			Z = Y.split(" ");
			if (2 === Z.length) {
				if (!isNaN(parseInt(Z[0], 0))) {
					V.css({
						left: Z[0]
					})
				}
				if (!isNaN(parseInt(Z[1], 0))) {
					V.css({
						top: Z[1]
					})
				}
			} else {
				switch (Y) {
				case "fill":
					this.fillContent(V, this._stageWidth, this._stageHeight);
					break;
				case "fit":
					this.fitContent(V, this._stageWidth, this._stageHeight);
					break;
				case "center":
					this.centerContent(V, this._stageWidth, this._stageHeight);
					break;
				case "stretch":
					this.stretchContent(V, this._stageWidth, this._stageHeight);
					break
				}
			}
			var aa = this._$stage.width() / this._stageWidth,
			ab = parseInt(V.css("top"), 0),
			X = parseInt(V.css("left"), 0),
			W = V.width(),
			ad = V.height();
			V.data({
				top: ab,
				left: X,
				width: W,
				height: ad
			}).css({
				top: Math.round(aa * ab),
				left: Math.round(aa * X)
			}).width(Math.round(aa * W)).height(Math.round(aa * ad));
			ac.data("ready", true)
		},
		centerContent: function (V, W, X) {
			V.css({
				top: (X - V.height()) / 2,
				left: (W - V.width()) / 2
			})
		},
		fillContent: function (W, Y, aa) {
			if ("auto" === Y || "auto" === aa) {
				return
			}
			var X = W.width(),
			V = W.height(),
			Z = Math.max(aa / V, Y / X);
			W.width(X * Z).height(V * Z);
			this.centerContent(W, Y, aa)
		},
		fitContent: function (W, aa, ab) {
			var Y = W.width(),
			V = W.height(),
			Z = aa / ab,
			X = Y / V;
			if (Z > X) {
				Y *= ab / V;
				V = ab
			} else {
				V *= aa / Y;
				Y = aa
			}
			W.width(Y).height(V);
			this.centerContent(W, aa, ab)
		},
		stretchContent: function (V, W, X) {
			V.css({
				top: 0,
				left: 0,
				width: W,
				height: X
			})
		},
		startTimer: function () {
			this._delay = this._$currItem.data("delay");
			this.resumeTimer()
		},
		resumeTimer: function () {
			if (this._rotate && 0 < this._delay) {
				this._start = new Date();
				this._timerId = setTimeout(y.proxy(this.rotateSlide, this), this._delay);
				if (typeof this._timer !== "undefined") {
					this._timer.start(this._delay)
				}
			}
		},
		resetTimer: function () {
			this._delay = 0;
			clearTimeout(this._timerId);
			if (typeof this._timer !== "undefined") {
				this._timer.stop()
			}
		},
		pauseTimer: function () {
			if (typeof this._start !== "undefined") {
				this._delay -= (new Date() - this._start)
			}
			clearTimeout(this._timerId);
			if (typeof this._timer !== "undefined") {
				this._timer.pause()
			}
		},
		initHorizontalScroll: function () {
			this._scrollEasing = ("easeOutCirc" in y.easing) ? "easeOutCirc": "linear";
			this._$rotator.bind(B, y.proxy(this.updateHorizontalThumbs, this));
			if (!R) {
				this._$thumbPanel.hover(y.proxy(function () {
					this._$rotator.unbind(B)
				},
				this), y.proxy(function () {
					this._$rotator.unbind(B).bind(B, y.proxy(this.updateHorizontalThumbs, this))
				},
				this)).mousemove(y.proxy(function (W) {
					var V = (W.pageX - this._$thumbPanel.offset().left) / this._$thumbPanel.width();
					this._$thumbList.animate({
						left: Math.round(this._$thumbPanel.data("range") * V)
					},
					{
						duration: M,
						easing: this._scrollEasing,
						queue: false
					})
				},
				this))
			}
		},
		initVerticalScroll: function () {
			this._scrollEasing = ("easeOutCirc" in y.easing) ? "easeOutCirc": "linear";
			this._$rotator.bind(B, y.proxy(this.updateVerticalThumbs, this));
			if (!R) {
				this._$thumbPanel.hover(y.proxy(function () {
					this._$rotator.unbind(B)
				},
				this), y.proxy(function () {
					this._$rotator.unbind(B).bind(B, y.proxy(this.updateVerticalThumbs, this))
				},
				this)).mousemove(y.proxy(function (W) {
					var V = (W.pageY - this._$thumbPanel.offset().top) / this._$thumbPanel.height();
					this._$thumbList.animate({
						top: Math.round(this._$thumbPanel.data("range") * V)
					},
					{
						duration: M,
						easing: this._scrollEasing,
						queue: false
					})
				},
				this))
			}
		},
		updateHorizontalThumbs: function () {
			var W = this._$thumbs.eq(this._currIndex).offset().left,
			V = this._$thumbPanel.offset().left;
			if (W < V) {
				this._$thumbList.animate({
					left: -this._currIndex * this._$thumbs.outerWidth(true)
				},
				{
					duration: M,
					easing: this._scrollEasing,
					queue: false
				})
			} else {
				if (W + this._$thumbs.width() > V + this._$thumbPanel.width()) {
					var X = (((this._numItems - 1) - this._currIndex) * this._$thumbs.outerWidth(true)) + this._$thumbPanel.data("range");
					this._$thumbList.animate({
						left: X
					},
					{
						duration: M,
						easing: this._scrollEasing,
						queue: false
					})
				}
			}
		},
		updateVerticalThumbs: function () {
			var W = this._$thumbs.eq(this._currIndex).offset().top,
			V = this._$thumbPanel.offset().top;
			if (W < V) {
				this._$thumbList.animate({
					top: -this._currIndex * this._$thumbs.outerHeight(true)
				},
				{
					duration: M,
					easing: this._scrollEasing,
					queue: false
				})
			} else {
				if (W + this._$thumbs.height() > V + this._$thumbPanel.height()) {
					var X = (((this._numItems - 1) - this._currIndex) * this._$thumbs.outerHeight(true)) + this._$thumbPanel.data("range");
					this._$thumbList.animate({
						top: X
					},
					{
						duration: M,
						easing: this._scrollEasing,
						queue: false
					})
				}
			}
		},
		resizeHorizontalCPanel: function () {
			this._$thumbPanel.width(Math.min(this._$screen.width() - this._$cpanel.data("margin") - this._$cpanel.data("buttonsSize"), this._$thumbList.width()));
			this._$cpanel.width(this._$cpanel.data("buttonsSize") + this._$thumbPanel.width());
			this._$cpWrapper.siblings(".br-ext-bg").width(this._$screen.width());
			this._$thumbList.stop();
			var V = this._$thumbPanel.width() - this._$thumbList.width();
			if (this._$thumbList.position().left < V) {
				this._$thumbList.css({
					left: V
				})
			}
			this._$thumbPanel.data({
				range: V
			});
			if ("center" === this._cpAlign[1]) {
				this._$cpanel.css({
					left: -this._$cpanel.outerWidth(true) / 2
				})
			}
		},
		resizeVerticalCPanel: function () {
			this._$thumbPanel.height(Math.min(this._$screen.height() - this._$cpanel.data("margin") - this._$cpanel.data("buttonsSize"), this._$thumbList.height()));
			this._$cpanel.height(this._$cpanel.data("buttonsSize") + this._$thumbPanel.height());
			this._$rotator.find(">.br-ext-cp").height(this._$screen.height());
			this._$thumbList.stop();
			var V = this._$thumbPanel.height() - this._$thumbList.height();
			if (this._$thumbList.position().top < V) {
				this._$thumbList.css({
					top: V
				})
			}
			this._$thumbPanel.data({
				range: V
			});
			if ("center" === this._cpAlign[1]) {
				this._$cpanel.css({
					top: -this._$cpanel.outerHeight(true) / 2
				})
			}
		},
		touchStart: function (V) {
			if (1 === V.originalEvent.touches.length) {
				this._startX = V.originalEvent.touches[0].pageX;
				this._startY = V.originalEvent.touches[0].pageY;
				this._$rotator.bind("touchmove", y.proxy(this.touchMove, this)).one("touchend", y.proxy(this.touchEnd, this))
			}
		},
		touchMove: function (X) {
			var V = this._startX - X.originalEvent.touches[0].pageX;
			var W = this._startY - X.originalEvent.touches[0].pageY;
			if ("verticalSlide" === this._options.effect) {
				this._swipeDist = W;
				this._scrolling = Math.abs(this._swipeDist) < Math.abs(V)
			} else {
				this._swipeDist = V;
				this._scrolling = Math.abs(this._swipeDist) < Math.abs(W)
			}
			if (!this._scrolling) {
				X.preventDefault()
			}
		},
		touchEnd: function (V) {
			this._$rotator.unbind("touchmove");
			if (!this._scrolling) {
				if (null !== this._swipeDist && Math.abs(this._swipeDist) > g) {
					if (this._swipeDist > 0) {
						this.nextSlide()
					} else {
						this.prevSlide()
					}
				}
			}
			this._startX = this._startY = this._swipeDist = null
		},
		mousescroll: function (V) {
			V.preventDefault();
			var W = (typeof V.originalEvent.wheelDelta === "undefined") ? -V.originalEvent.detail: V.originalEvent.wheelDelta;
			if (W > 0) {
				this.prevSlide()
			} else {
				this.nextSlide()
			}
		},
		keyControl: function (V) {
			switch (V.keyCode) {
			case 37:
				this.prevSlide();
				break;
			case 39:
				this.nextSlide();
				break;
			case 80:
				this.togglePlay();
				break
			}
		},
		resize: function () {
			this.resetTimer();
			this.clearLayers(false);
			var V = this._$stage.width() / this._stageWidth;
			this._$stage.height(Math.round(V * this._stageHeight));
			this._$screen.width(this._$stage.width()).height(this._$stage.height());
			y.each(this._effects, function (X, Y) {
				Y.resize(V)
			});
			this._$items.each(function () {
				if (y(this).data("ready")) {
					var X = y(this).find(">img.br-main-img");
					X.css({
						top: Math.round(V * X.data("top")),
						left: Math.round(V * X.data("left"))
					}).width(Math.round(V * X.data("width"))).height(Math.round(V * X.data("height")))
				}
			});
			this._$layers.each(function () {
				var Y = y(this).data(),
				X = {};
				if (!isNaN(Y.width)) {
					X.width = Math.ceil(V * Y.width) + "px"
				}
				if (!isNaN(Y.height)) {
					X.height = Math.ceil(V * Y.height) + "px"
				}
				y(this).css({
					paddingTop: Math.round(V * Y.padTop) + "px",
					paddingBottom: Math.round(V * Y.padBottom) + "px",
					paddingLeft: Math.round(V * Y.padLeft) + "px",
					paddingRight: Math.round(V * Y.padRight) + "px",
					borderTopWidth: Math.round(V * Y.borderTop) + "px",
					borderBottomWidth: Math.round(V * Y.borderBottom) + "px",
					borderLeftWidth: Math.round(V * Y.borderLeft) + "px",
					borderRightWidth: Math.round(V * Y.borderRight) + "px",
					fontSize: Math.floor(V * Y.fontSize) + "px",
					lineHeight: Math.floor(V * Y.lineHeight) + "px"
				}).css(X)
			});
			this._$rotator.trigger(b);
			var W = this._$items.eq(this._currIndex);
			if (W.data("ready")) {
				this._$items.css({
					visibility: "hidden"
				});
				W.css({
					visibility: "visible"
				});
				this.displayLayers();
				this.startTimer()
			}
		},
		getEffect: function (V) {
			if (!this._cssTransform) {
				if ( - 1 < y.inArray(V, ["zoomIn", "zoomOut", "flipDown", "flipUp", "flipRight", "flipLeft"])) {
					V = "fade"
				}
			}
			return V
		},
		shuffleItems: function (W) {
			var V = W.children("li").toArray();
			o(V);
			W.append(V)
		},
		checkEasing: function (V) {
			if (this._cssTransition) {
				if (! (V in K)) {
					V = "ease"
				}
			} else {
				if (! (V in y.easing)) {
					V = "swing"
				}
			}
			return V
		},
		onTooltip: function (V) {
			if (q && document.elementFromPoint) {
				return y(document.elementFromPoint(V.clientX, V.clientY)).closest(".br-tt").is(this._$tooltip)
			}
			return false
		},
		getVerticalOffset: function (V, X) {
			var W;
			if ("marginBottom" === V.data("verticalMargin")) {
				X = !X;
				W = V[0].style.bottom
			} else {
				W = V[0].style.top
			}
			W = Math.ceil(parseFloat(W) / 100 * this._$screen.height());
			return X ? -(W + V.outerHeight() + 1) : (this._$screen.height() - W) + 1
		},
		getHorizontalOffset: function (X, W) {
			var V;
			if ("marginRight" === X.data("horizontalMargin")) {
				W = !W;
				V = X[0].style.right
			} else {
				V = X[0].style.left
			}
			V = Math.ceil(parseFloat(V) / 100 * this._$screen.width());
			return W ? -(V + X.outerWidth() + 1) : (this._$screen.width() - V) + 1
		}
	};
	function C(V) {
		V.preventDefault()
	}
	function c(V, W) {
		return parseInt(V, 0) || W
	}
	function J(V, W) {
		V = parseInt(V, 0);
		return (isNaN(V) || V <= 0) ? W: V
	}
	function G(V, W) {
		V = parseInt(V, 0);
		return (isNaN(V) || V < 0) ? W: V
	}
	function x(V, W) {
		return parseFloat(V) || W
	}
	function E(V, W) {
		return (typeof V !== "undefined") ? V: W
	}
	function D(V) {
		return (V.indexOf("%") > 0)
	}
	function l(ac) {
		var aa = ["Webkit", "Moz", "O", "ms"],
		Z = document.body || document.documentElement,
		X = Z.style,
		W = false;
		if (typeof X[ac] !== "undefined") {
			W = ac
		} else {
			var Y = ac.charAt(0).toUpperCase() + ac.slice(1);
			for (var V = 0; V < aa.length; V++) {
				var ab = aa[V] + Y;
				if (typeof X[ab] !== "undefined") {
					W = ab;
					break
				}
			}
		}
		y.support[ac] = W;
		return W
	}
	function a(V) {
		if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)) {
			if (typeof V === "undefined") {
				return true
			}
			var W = new Number(RegExp.$1);
			if (W <= V) {
				return true
			}
		}
		return false
	}
	function o(V) {
		var Y = V.length;
		while (--Y > 0) {
			var W = Math.floor(Math.random() * (Y + 1)),
			X = V[Y];
			V[Y] = V[W];
			V[W] = X
		}
	}
	y.fn.copyBorder = function (Y) {
		var X = ["top", "bottom", "left", "right"],
		W = ["width", "style", "color"],
		V = ["borderRadiusTopLeft", "borderRadiusTopRight", "borderRadiusBottomLeft", "borderRadiusBottomRight"];
		return this.each(function () {
			for (var ab = 0; ab < X.length; ab++) {
				for (var aa = 0; aa < W.length; aa++) {
					var Z = "border-" + X[ab] + "-" + W[aa];
					y(this).css(Z, Y.css(Z))
				}
			}
			for (var aa = 0; aa < V.length; aa++) {
				y(this).css(V[aa], Y.css(V[aa]))
			}
		})
	};
	y.fn.transition = function (V, W, Y, X) {
		return this.each(function () {
			y(this).queue(function () {
				if (y.isFunction(X)) {
					y(this).one(O, X)
				}
				y(this).one(O, function () {
					y(this).css(f, "none").css(f + "-duration", "0s").dequeue()
				});
				V[f] = "all " + W + "ms " + K[Y];
				y(this).reflow().css(V)
			})
		})
	};
	y.fn.stopTransition = function (V, W) {
		return this.each(function () {
			if (V) {
				y(this).clearQueue()
			}
			if (W) {
				y(this).trigger(O)
			} else {
				y(this).unbind(O)
			}
			y(this).css(f, "none").css(f + "-duration", "0s")
		})
	};
	y.fn.reflow = function () {
		return this.each(function () {
			var V = this.offsetWidth
		})
	};
	y.fn.forceTransitionEnd = function (V) {
		return this.each(function () {
			var W = false;
			y(this).one(O, function () {
				W = true
			});
			setTimeout(y.proxy(function () {
				if (!W) {
					y(this).trigger(O)
				}
			},
			this), V)
		})
	};
	if (y.cssHooks && y.support.borderRadius) {
		function k(V) {
			var W = ("borderRadius" === y.support.borderRadius) ? "border": y.support.borderRadius.replace("BorderRadius", "") + "Border";
			if ("MozBorderRadius" === y.support.borderRadius) {
				return "MozBorderRadius" + V.charAt(0).toUpperCase() + V.substr(1).toLowerCase()
			} else {
				return W + V + "Radius"
			}
		}
		y.each(["TopLeft", "TopRight", "BottomRight", "BottomLeft"], function (W, V) {
			y.cssHooks["borderRadius" + V] = {
				get: function (Z, Y, X) {
					return y.css(Z, k(V))
				},
				set: function (X, Y) {
					X.style[k(V)] = Y
				}
			}
		})
	}
	var A = {
		play: function () {
			y(this).data(u).play()
		},
		pause: function () {
			y(this).data(u).pause()
		},
		previous: function () {
			y(this).data(u).prevSlide()
		},
		next: function () {
			y(this).data(u).nextSlide()
		},
		destroy: function () {
			var V = y(this).data(u);
			V.pause();
			if (typeof V._namespace !== "undefined" && "" !== V._namespace) {
				y(window).add(y(document)).unbind(V._namespace)
			}
			V._$rotator.add(y("*", V._$rotator)).unbind().removeData();
			y(this).removeData(u)
		}
	};
	var z = {
		width: 1000,
		height: 300,
		thumbWidth: 28,
		thumbHeight: 28,
		thumbMargin: 3,
		buttonWidth: 28,
		buttonHeight: 28,
		buttonMargin: 3,
		tooltipWidth: "auto",
		tooltipHeight: "auto",
		backgroundRepeat: "repeat",
		backgroundPosition: "center center",
		startIndex: 0,
		autoPlay: true,
		delay: 6000,
		playOnce: false,
		pauseOnHover: false,
		pauseOnInteraction: false,
		effect: "fade",
		duration: 800,
		easing: "",
		cpanelAlign: "bottom",
		cpanelOutside: false,
		cpanelOnHover: false,
		thumbnails: "number",
		selectOnHover: false,
		tooltip: "text",
		tooltipDelay: 0,
		playButton: true,
		timer: "pie",
		timerAlign: "topRight",
		navButtons: "small",
		navButtonsOnHover: false,
		layerEffect: "fade",
		layerDuration: M,
		layerEasing: "",
		layerDelay: 0,
		layerEffectOut: "fade",
		layerDurationOut: M,
		layerEasingOut: "",
		layerDelayOut: -1,
		layerSync: true,
		layerOutSync: true,
		imagePosition: "fill",
		blockCols: 12,
		blockRows: 4,
		verticalSlices: 14,
		horizontalSlices: 6,
		blockDelay: 25,
		verticalSliceDelay: 75,
		horizontalSliceDelay: 75,
		shuffle: false,
		mousewheel: false,
		keyboard: true,
		swipe: true,
		cssTransition: true,
		responsive: true,
		onInit: function () {},
		onSlideChange: function () {},
		onSlideComplete: function () {},
		onFirstSlide: function () {},
		onLastSlide: function () {},
		onPlay: function () {},
		onPause: function () {},
		onPrev: function () {},
		onNext: function () {}
	};
	y.fn.bannerRotator = function () {
		var V = arguments;
		var W = V[0];
		return this.each(function (Z, X) {
			if (A[W]) {
				if (typeof y(X).data(u) !== "undefined") {
					A[W].apply(X, Array.prototype.slice.call(V, 1))
				}
			} else {
				if (typeof W === "object" || !W) {
					var Y = new F(X, y.extend({},
					z, W));
					y(X).data(u, Y);
					Y._$rotator.trigger(e);
					Y._options.onInit.call(Y)
				}
			}
		})
	}
})(jQuery);